/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.interceptor;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.InterceptorContext;
import software.amazon.awssdk.core.internal.interceptor.DefaultFailedExecutionContext;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkProtectedApi
public class ExecutionInterceptorChain {
    private static final Logger LOG = Logger.loggerFor(ExecutionInterceptorChain.class);
    private final List<ExecutionInterceptor> interceptors;

    public ExecutionInterceptorChain(List<ExecutionInterceptor> interceptors) {
        this.interceptors = new ArrayList<ExecutionInterceptor>((Collection)Validate.paramNotNull(interceptors, (String)"interceptors"));
        LOG.debug(() -> "Creating an interceptor chain that will apply interceptors in the following order: " + interceptors);
    }

    public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
        this.interceptors.forEach(i -> i.beforeExecution(context, executionAttributes));
    }

    public InterceptorContext modifyRequest(InterceptorContext context, ExecutionAttributes executionAttributes) {
        InterceptorContext result = context;
        for (ExecutionInterceptor interceptor : this.interceptors) {
            SdkRequest interceptorResult = interceptor.modifyRequest(result, executionAttributes);
            if (interceptorResult == result.request()) continue;
            this.validateInterceptorResult(result.request(), interceptorResult, interceptor, "modifyRequest");
            result = (InterceptorContext)result.copy(b -> b.request(interceptorResult));
        }
        return result;
    }

    public void beforeMarshalling(Context.BeforeMarshalling context, ExecutionAttributes executionAttributes) {
        this.interceptors.forEach(i -> i.beforeMarshalling(context, executionAttributes));
    }

    public void afterMarshalling(Context.AfterMarshalling context, ExecutionAttributes executionAttributes) {
        this.interceptors.forEach(i -> i.afterMarshalling(context, executionAttributes));
    }

    public InterceptorContext modifyHttpRequestAndHttpContent(InterceptorContext context, ExecutionAttributes executionAttributes) {
        InterceptorContext result = context;
        for (ExecutionInterceptor interceptor : this.interceptors) {
            AsyncRequestBody asyncRequestBody = interceptor.modifyAsyncHttpContent(result, executionAttributes).orElse(null);
            RequestBody requestBody = interceptor.modifyHttpContent(result, executionAttributes).orElse(null);
            SdkHttpRequest interceptorResult = interceptor.modifyHttpRequest(result, executionAttributes);
            if (asyncRequestBody == result.asyncRequestBody().orElse(null) && requestBody == result.requestBody().orElse(null) && interceptorResult == result.httpRequest()) continue;
            this.validateInterceptorResult(result.httpRequest(), interceptorResult, interceptor, "modifyHttpRequest");
            result = (InterceptorContext)result.copy(r -> r.httpRequest(interceptorResult).asyncRequestBody(asyncRequestBody).requestBody(requestBody));
        }
        return result;
    }

    public void beforeTransmission(Context.BeforeTransmission context, ExecutionAttributes executionAttributes) {
        this.interceptors.forEach(i -> i.beforeTransmission(context, executionAttributes));
    }

    public void afterTransmission(Context.AfterTransmission context, ExecutionAttributes executionAttributes) {
        this.reverseForEach(i -> i.afterTransmission(context, executionAttributes));
    }

    public InterceptorContext modifyHttpResponse(InterceptorContext context, ExecutionAttributes executionAttributes) {
        InterceptorContext result = context;
        for (int i = this.interceptors.size() - 1; i >= 0; --i) {
            SdkHttpResponse interceptorResult = this.interceptors.get(i).modifyHttpResponse(result, executionAttributes);
            InputStream response = this.interceptors.get(i).modifyHttpResponseContent(result, executionAttributes).orElse(null);
            if (interceptorResult == result.httpResponse() && response == result.responseBody().orElse(null)) continue;
            this.validateInterceptorResult(result.httpResponse(), interceptorResult, this.interceptors.get(i), "modifyHttpResponse");
            result = (InterceptorContext)result.copy(r -> r.httpResponse(interceptorResult).responseBody(response));
        }
        return result;
    }

    public InterceptorContext modifyAsyncHttpResponse(InterceptorContext context, ExecutionAttributes executionAttributes) {
        InterceptorContext result = context;
        for (int i = this.interceptors.size() - 1; i >= 0; --i) {
            ExecutionInterceptor interceptor = this.interceptors.get(i);
            Publisher newResponsePublisher = interceptor.modifyAsyncHttpResponseContent(result, executionAttributes).orElse(null);
            if (newResponsePublisher == result.responsePublisher().orElse(null)) continue;
            result = (InterceptorContext)result.copy(r -> r.responsePublisher((Publisher<ByteBuffer>)newResponsePublisher));
        }
        return result;
    }

    public void beforeUnmarshalling(Context.BeforeUnmarshalling context, ExecutionAttributes executionAttributes) {
        this.reverseForEach(i -> i.beforeUnmarshalling(context, executionAttributes));
    }

    public void afterUnmarshalling(Context.AfterUnmarshalling context, ExecutionAttributes executionAttributes) {
        this.reverseForEach(i -> i.afterUnmarshalling(context, executionAttributes));
    }

    public InterceptorContext modifyResponse(InterceptorContext context, ExecutionAttributes executionAttributes) {
        InterceptorContext result = context;
        for (int i = this.interceptors.size() - 1; i >= 0; --i) {
            SdkResponse interceptorResult = this.interceptors.get(i).modifyResponse(result, executionAttributes);
            if (interceptorResult == result.response()) continue;
            this.validateInterceptorResult(result.response(), interceptorResult, this.interceptors.get(i), "modifyResponse");
            result = (InterceptorContext)result.copy(b -> b.response(interceptorResult));
        }
        return result;
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        this.reverseForEach(i -> i.afterExecution(context, executionAttributes));
    }

    public DefaultFailedExecutionContext modifyException(DefaultFailedExecutionContext context, ExecutionAttributes executionAttributes) {
        DefaultFailedExecutionContext result = context;
        for (int i = this.interceptors.size() - 1; i >= 0; --i) {
            Throwable interceptorResult = this.interceptors.get(i).modifyException(result, executionAttributes);
            if (interceptorResult == result.exception()) continue;
            this.validateInterceptorResult(result.exception(), interceptorResult, this.interceptors.get(i), "modifyException");
            result = (DefaultFailedExecutionContext)result.copy(b -> b.exception(interceptorResult));
        }
        return result;
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        this.interceptors.forEach(i -> i.onExecutionFailure(context, executionAttributes));
    }

    private void validateInterceptorResult(Object originalMessage, Object newMessage, ExecutionInterceptor interceptor, String methodName) {
        if (!Objects.equals(originalMessage, newMessage)) {
            LOG.debug(() -> "Interceptor '" + interceptor + "' modified the message with its " + methodName + " method.");
            LOG.trace(() -> "Old: " + originalMessage + "\nNew: " + newMessage);
        }
        Validate.validState((newMessage != null ? 1 : 0) != 0, (String)"Request interceptor '%s' returned null from its %s interceptor.", (Object[])new Object[]{interceptor, methodName});
        Validate.isInstanceOf(originalMessage.getClass(), (Object)newMessage, (String)"Request interceptor '%s' returned '%s' from its %s method, but '%s' was expected.", (Object[])new Object[]{interceptor, newMessage.getClass(), methodName, originalMessage.getClass()});
    }

    private void reverseForEach(Consumer<ExecutionInterceptor> action) {
        for (int i = this.interceptors.size() - 1; i >= 0; --i) {
            action.accept(this.interceptors.get(i));
        }
    }
}

