/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import software.amazon.awssdk.core.internal.http.InterruptMonitor;
import software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import software.amazon.awssdk.core.internal.util.MetricUtils;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.http.Abortable;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
public class MakeHttpRequestStage
implements RequestPipeline<SdkHttpFullRequest, Pair<SdkHttpFullRequest, SdkHttpFullResponse>> {
    private final SdkHttpClient sdkHttpClient;

    public MakeHttpRequestStage(HttpClientDependencies dependencies) {
        this.sdkHttpClient = dependencies.clientConfiguration().option(SdkClientOption.SYNC_HTTP_CLIENT);
    }

    @Override
    public Pair<SdkHttpFullRequest, SdkHttpFullResponse> execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        InterruptMonitor.checkInterrupted();
        HttpExecuteResponse executeResponse = this.executeHttpRequest(request, context);
        SdkHttpFullResponse httpResponse = (SdkHttpFullResponse)executeResponse.httpResponse();
        return Pair.of((Object)request, (Object)httpResponse.toBuilder().content((AbortableInputStream)executeResponse.responseBody().orElse(null)).build());
    }

    private HttpExecuteResponse executeHttpRequest(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        MetricCollector attemptMetricCollector = context.attemptMetricCollector();
        MetricCollector httpMetricCollector = MetricUtils.createHttpMetricsCollector(context);
        ExecutableHttpRequest requestCallable = this.sdkHttpClient.prepareRequest(HttpExecuteRequest.builder().request((SdkHttpRequest)request).metricCollector(httpMetricCollector).contentStreamProvider((ContentStreamProvider)request.contentStreamProvider().orElse(null)).build());
        context.apiCallTimeoutTracker().abortable((Abortable)requestCallable);
        context.apiCallAttemptTimeoutTracker().abortable((Abortable)requestCallable);
        long start = MakeHttpRequestStage.updateMetricCollectionAttributes(context);
        Pair measuredExecute = MetricUtils.measureDurationUnsafe(requestCallable, start);
        Duration executeDuration = (Duration)measuredExecute.right();
        attemptMetricCollector.reportMetric(CoreMetric.SERVICE_CALL_DURATION, (Object)executeDuration);
        attemptMetricCollector.reportMetric(CoreMetric.TIME_TO_FIRST_BYTE, (Object)executeDuration);
        context.executionAttributes().putAttribute(SdkInternalExecutionAttribute.HEADERS_READ_END_NANO_TIME, start + executeDuration.toNanos());
        return (HttpExecuteResponse)measuredExecute.left();
    }

    private static long updateMetricCollectionAttributes(RequestExecutionContext context) {
        long now = System.nanoTime();
        context.executionAttributes().putAttribute(SdkInternalExecutionAttribute.API_CALL_ATTEMPT_START_NANO_TIME, now);
        return now;
    }
}

