/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.http.pipeline.stages.utils;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.Response;
import software.amazon.awssdk.core.SdkStandardLogger;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.internal.InternalCoreExecutionAttribute;
import software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import software.amazon.awssdk.core.internal.http.pipeline.stages.utils.RetryableStageHelper;
import software.amazon.awssdk.core.internal.retry.ClockSkewAdjuster;
import software.amazon.awssdk.core.internal.retry.RetryPolicyAdapter;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.retries.api.AcquireInitialTokenRequest;
import software.amazon.awssdk.retries.api.AcquireInitialTokenResponse;
import software.amazon.awssdk.retries.api.RecordSuccessRequest;
import software.amazon.awssdk.retries.api.RefreshRetryTokenRequest;
import software.amazon.awssdk.retries.api.RefreshRetryTokenResponse;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.retries.api.RetryToken;
import software.amazon.awssdk.retries.api.TokenAcquisitionFailedException;

@SdkInternalApi
public final class RetryableStageHelper2 {
    public static final String SDK_RETRY_INFO_HEADER = "amz-sdk-request";
    private final SdkHttpFullRequest request;
    private final RequestExecutionContext context;
    private RetryPolicyAdapter retryPolicyAdapter;
    private final RetryStrategy retryStrategy;
    private final HttpClientDependencies dependencies;
    private final List<String> exceptionMessageHistory = new ArrayList<String>();
    private int attemptNumber = 0;
    private SdkHttpResponse lastResponse;
    private SdkException lastException;

    public RetryableStageHelper2(SdkHttpFullRequest request, RequestExecutionContext context, HttpClientDependencies dependencies) {
        this.request = request;
        this.context = context;
        RetryPolicy retryPolicy = dependencies.clientConfiguration().option(SdkClientOption.RETRY_POLICY);
        RetryStrategy retryStrategy = dependencies.clientConfiguration().option(SdkClientOption.RETRY_STRATEGY);
        if (retryPolicy != null) {
            this.retryPolicyAdapter = RetryPolicyAdapter.builder().retryPolicy(retryPolicy).build();
        } else if (retryStrategy instanceof RetryPolicyAdapter) {
            this.retryPolicyAdapter = (RetryPolicyAdapter)retryStrategy;
        }
        this.retryStrategy = retryStrategy;
        this.dependencies = dependencies;
    }

    public void startingAttempt() {
        ++this.attemptNumber;
        this.context.executionAttributes().putAttribute(InternalCoreExecutionAttribute.EXECUTION_ATTEMPT, this.attemptNumber);
    }

    public Duration acquireInitialToken() {
        String scope = "GLOBAL";
        AcquireInitialTokenRequest acquireRequest = AcquireInitialTokenRequest.create((String)scope);
        AcquireInitialTokenResponse acquireResponse = this.retryStrategy().acquireInitialToken(acquireRequest);
        RetryToken retryToken = acquireResponse.token();
        Duration delay = acquireResponse.delay();
        this.context.executionAttributes().putAttribute(InternalCoreExecutionAttribute.RETRY_TOKEN, retryToken);
        this.context.executionAttributes().putAttribute(RetryableStageHelper.LAST_BACKOFF_DELAY_DURATION, delay);
        return delay;
    }

    public void recordAttemptSucceeded() {
        RetryToken retryToken = this.context.executionAttributes().getAttribute(InternalCoreExecutionAttribute.RETRY_TOKEN);
        RecordSuccessRequest recordSuccessRequest = RecordSuccessRequest.create((RetryToken)retryToken);
        this.retryStrategy().recordSuccess(recordSuccessRequest);
        this.context.executionContext().metricCollector().reportMetric(CoreMetric.RETRY_COUNT, (Object)this.retriesAttemptedSoFar());
    }

    public Optional<Duration> tryRefreshToken(Duration suggestedDelay) {
        RefreshRetryTokenResponse refreshResponse;
        RetryToken retryToken = this.context.executionAttributes().getAttribute(InternalCoreExecutionAttribute.RETRY_TOKEN);
        try {
            RefreshRetryTokenRequest refreshRequest = RefreshRetryTokenRequest.builder().failure((Throwable)this.lastException).token(retryToken).suggestedDelay(suggestedDelay).build();
            refreshResponse = this.retryStrategy().refreshRetryToken(refreshRequest);
        }
        catch (TokenAcquisitionFailedException e) {
            this.context.executionAttributes().putAttribute(InternalCoreExecutionAttribute.RETRY_TOKEN, e.token());
            return Optional.empty();
        }
        Duration delay = refreshResponse.delay();
        this.context.executionAttributes().putAttribute(InternalCoreExecutionAttribute.RETRY_TOKEN, refreshResponse.token());
        this.context.executionAttributes().putAttribute(RetryableStageHelper.LAST_BACKOFF_DELAY_DURATION, delay);
        return Optional.of(delay);
    }

    public SdkException retryPolicyDisallowedRetryException() {
        this.context.executionContext().metricCollector().reportMetric(CoreMetric.RETRY_COUNT, (Object)this.retriesAttemptedSoFar());
        for (int i = 0; i < this.exceptionMessageHistory.size() - 1; ++i) {
            SdkClientException pastException = SdkClientException.builder().message("Request attempt " + (i + 1) + " failure: " + this.exceptionMessageHistory.get(i)).writableStackTrace(false).build();
            this.lastException.addSuppressed(pastException);
        }
        return this.lastException;
    }

    public void logBackingOff(Duration backoffDelay) {
        SdkStandardLogger.REQUEST_LOGGER.debug(() -> "Retryable error detected. Will retry in " + backoffDelay.toMillis() + "ms. Request attempt number " + this.attemptNumber, (Throwable)this.lastException);
    }

    public SdkHttpFullRequest requestToSend() {
        return this.request.toBuilder().putHeader(SDK_RETRY_INFO_HEADER, "attempt=" + this.attemptNumber + "; max=" + this.retryStrategy().maxAttempts()).build();
    }

    public void logSendingRequest() {
        SdkStandardLogger.REQUEST_LOGGER.debug(() -> (this.isInitialAttempt() ? "Sending" : "Retrying") + " Request: " + this.request);
    }

    public void adjustClockIfClockSkew(Response<?> response) {
        ClockSkewAdjuster clockSkewAdjuster = this.dependencies.clockSkewAdjuster();
        if (!response.isSuccess().booleanValue() && clockSkewAdjuster.shouldAdjust(response.exception())) {
            this.dependencies.updateTimeOffset(clockSkewAdjuster.getAdjustmentInSeconds((SdkHttpResponse)response.httpResponse()));
        }
    }

    public SdkException getLastException() {
        return this.lastException;
    }

    public void setLastException(Throwable lastException) {
        if (lastException instanceof CompletionException) {
            this.setLastException(lastException.getCause());
        } else if (lastException instanceof SdkException) {
            this.lastException = (SdkException)lastException;
            this.exceptionMessageHistory.add(this.lastException.getMessage());
        } else {
            this.lastException = SdkClientException.create("Unable to execute HTTP request: " + lastException.getMessage(), lastException);
            this.exceptionMessageHistory.add(this.lastException.getMessage());
        }
    }

    public void setLastResponse(SdkHttpResponse lastResponse) {
        this.lastResponse = lastResponse;
    }

    private boolean isInitialAttempt() {
        return this.attemptNumber == 1;
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    private int retriesAttemptedSoFar() {
        return Math.max(0, this.attemptNumber - 1);
    }

    private RetryStrategy retryStrategy() {
        if (this.retryPolicyAdapter != null) {
            this.retryPolicyAdapter = this.retryPolicyAdapter.isInitialized() ? this.retryPolicyAdapter.toBuilder().retryPolicyContext(this.retryPolicyContext()).build() : this.retryPolicyAdapter.toBuilder().initialize(this.retryPolicyContext()).build();
            return this.retryPolicyAdapter;
        }
        return this.retryStrategy;
    }

    private RetryPolicyContext retryPolicyContext() {
        return RetryPolicyContext.builder().request(this.request).originalRequest(this.context.originalRequest()).exception(this.lastException).retriesAttempted(this.retriesAttemptedSoFar()).executionAttributes(this.context.executionAttributes()).httpStatusCode(this.lastResponse == null ? null : Integer.valueOf(this.lastResponse.statusCode())).build();
    }
}

