/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.useragent;

import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.internal.useragent.SdkClientUserAgentProperties;
import software.amazon.awssdk.core.internal.useragent.UserAgentConstant;
import software.amazon.awssdk.core.util.SystemUserAgent;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.StringUtils;

@ThreadSafe
@SdkProtectedApi
public final class SdkUserAgentBuilder {
    private static final Logger log = Logger.loggerFor(SdkUserAgentBuilder.class);

    private SdkUserAgentBuilder() {
    }

    public static String buildClientUserAgentString(SystemUserAgent systemValues, SdkClientUserAgentProperties userAgentProperties) {
        String appId;
        String retryMode;
        StringBuilder uaString = new StringBuilder(255);
        UserAgentConstant.appendNonEmptyField(uaString, "aws-sdk-java", systemValues.sdkVersion());
        SdkUserAgentBuilder.appendAdditionalSdkMetadata(uaString, userAgentProperties);
        String internalMarkerValue = userAgentProperties.getProperty("internal");
        if (!StringUtils.isEmpty((CharSequence)internalMarkerValue)) {
            UserAgentConstant.appendFieldAndSpace(uaString, "md", "internal");
        }
        UserAgentConstant.appendNonEmptyField(uaString, "ua", "2.0");
        UserAgentConstant.appendNonEmptyField(uaString, "os", systemValues.osMetadata());
        UserAgentConstant.appendNonEmptyField(uaString, "lang", systemValues.langMetadata());
        SdkUserAgentBuilder.appendAdditionalJvmMetadata(uaString, systemValues);
        String envMetadata = systemValues.envMetadata();
        if (!SdkUserAgentBuilder.isEmptyOrUnknown(envMetadata)) {
            UserAgentConstant.appendFieldAndSpace(uaString, "exec-env", envMetadata);
        }
        if (!StringUtils.isEmpty((CharSequence)(retryMode = userAgentProperties.getProperty("retry-mode")))) {
            UserAgentConstant.appendFieldAndSpace(uaString, "cfg", UserAgentConstant.uaPair("retry-mode", retryMode));
        }
        if (!StringUtils.isEmpty((CharSequence)(appId = userAgentProperties.getProperty("app")))) {
            SdkUserAgentBuilder.checkLengthAndWarn(appId);
            UserAgentConstant.appendFieldAndSpace(uaString, "app", appId);
        }
        SdkUserAgentBuilder.removeFinalWhitespace(uaString);
        return uaString.toString();
    }

    public static String buildSystemUserAgentString(SystemUserAgent systemValues) {
        StringBuilder uaString = new StringBuilder(128);
        UserAgentConstant.appendNonEmptyField(uaString, "aws-sdk-java", systemValues.sdkVersion());
        UserAgentConstant.appendNonEmptyField(uaString, "os", systemValues.osMetadata());
        UserAgentConstant.appendNonEmptyField(uaString, "lang", systemValues.langMetadata());
        SdkUserAgentBuilder.appendAdditionalJvmMetadata(uaString, systemValues);
        String envMetadata = systemValues.envMetadata();
        if (!SdkUserAgentBuilder.isEmptyOrUnknown(envMetadata)) {
            UserAgentConstant.appendFieldAndSpace(uaString, "exec-env", systemValues.envMetadata());
        }
        SdkUserAgentBuilder.removeFinalWhitespace(uaString);
        return uaString.toString();
    }

    private static void removeFinalWhitespace(StringBuilder builder) {
        if (builder.length() > 0 && builder.charAt(builder.length() - 1) == ' ') {
            builder.deleteCharAt(builder.length() - 1);
        }
    }

    private static boolean isEmptyOrUnknown(String envMetadata) {
        return StringUtils.isEmpty((CharSequence)envMetadata) || envMetadata.equalsIgnoreCase("unknown");
    }

    private static void appendAdditionalSdkMetadata(StringBuilder builder, SdkClientUserAgentProperties userAgentProperties) {
        UserAgentConstant.appendNonEmptyField(builder, "md", UserAgentConstant.uaPairOrNull("io", userAgentProperties.getProperty("io")));
        UserAgentConstant.appendNonEmptyField(builder, "md", UserAgentConstant.uaPairOrNull("http", userAgentProperties.getProperty("http")));
    }

    private static void appendAdditionalJvmMetadata(StringBuilder builder, SystemUserAgent systemProperties) {
        UserAgentConstant.appendNonEmptyField(builder, "md", systemProperties.vmMetadata());
        UserAgentConstant.appendNonEmptyField(builder, "md", systemProperties.vendorMetadata());
        systemProperties.languageTagMetadata().ifPresent(value -> UserAgentConstant.appendFieldAndSpace(builder, "md", value));
        for (String lang : systemProperties.additionalJvmLanguages()) {
            UserAgentConstant.appendNonEmptyField(builder, "md", lang);
        }
    }

    private static void checkLengthAndWarn(String appId) {
        if (appId.length() > 50) {
            log.warn(() -> String.format("The configured appId '%s' is longer than the recommended maximum length of 50. This could result in not being able to transmit and log the whole user agent string, including the complete value of this string.", appId));
        }
    }
}

