# database.py

from sqlalchemy import create_engine
from sqlalchemy.orm import sessionmaker
from gina.models import Base  # Import the Base from models to create tables
from dotenv import load_dotenv
import os

# Load the .env file
load_dotenv()

# Access variables
DATABASE_URL = os.getenv("DATABASE_URL")
 # Update with your database URL

engine = create_engine(DATABASE_URL, echo=True)
Session = sessionmaker(bind=engine)

def init_db():
    Base.metadata.create_all(engine)  # Create tables

# Create a session factory
def get_session():
    return Session()
