from sqlalchemy import Column, Integer, String, ForeignKey, DateTime, func
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import relationship
from datetime import datetime

Base = declarative_base()

class User(Base):
    __tablename__ = 'users'
    
    id = Column(Integer, primary_key=True)
    name = Column(String(100), nullable=False)
    email = Column(String(255), unique=True, nullable=True)
    created_at = Column(DateTime, default=func.now(), nullable=False) 
    updated_at = Column(DateTime, nullable=True)
    likes = relationship("Likepostsgroup", back_populates="user")
    comments = relationship("Commentspostsgroup", back_populates="user")
    likes_comments = relationship("LikesCommentspostsgroup", back_populates="user")
    user_subscription = relationship("UserSubscription", back_populates="user")
    user_links = relationship("UserLinks", back_populates="user")

    def __repr__(self):
        return f"<User(id={self.id}, name={self.name}, email={self.email})>"

class Likepostsgroup(Base):
    __tablename__ = 'likes_group'
    
    id = Column(Integer, primary_key=True)
    name = Column(String(100), nullable=True)
    user_id = Column(Integer, ForeignKey('users.id'))
    created_at = Column(DateTime, default=func.now(), nullable=False) 
    updated_at = Column(DateTime, nullable=True)
    
    user = relationship("User", back_populates="likes")

class Commentspostsgroup(Base):
    __tablename__ = 'comments_group'
    
    id = Column(Integer, primary_key=True)
    name = Column(String(100), nullable=True)
    user_id = Column(Integer, ForeignKey('users.id'))
    created_at = Column(DateTime, default=func.now(), nullable=False) 
    updated_at = Column(DateTime, nullable=True)
    
    user = relationship("User", back_populates="comments")

class LikesCommentspostsgroup(Base):
    __tablename__ = 'likes_comments_group'
    
    id = Column(Integer, primary_key=True)
    name = Column(String(100), nullable=True)
    user_id = Column(Integer, ForeignKey('users.id'))
    created_at = Column(DateTime, default=func.now(), nullable=False) 
    updated_at = Column(DateTime, nullable=True)
    
    user = relationship("User", back_populates="likes_comments")

class UserSubscription(Base):
    __tablename__ = 'user_subscription'
    
    id = Column(Integer, primary_key=True)
    type = Column(String(100), nullable=True)
    user_id = Column(Integer, ForeignKey('users.id'))
    insta_username = Column(String(555), unique=False, nullable=True)
    payment_method = Column(String(100), nullable=True)
    start_date = Column(DateTime, nullable=True)
    end_date = Column(DateTime, nullable=True)
    renewal_date = Column(DateTime, nullable=True)
    created_at = Column(DateTime, default=func.now(), nullable=False) 
    updated_at = Column(DateTime, nullable=True)

    user = relationship("User", back_populates="user_subscription")

class UserLinks(Base):
    __tablename__ = 'user_links'
    
    id = Column(Integer, primary_key=True)
    user_id = Column(Integer, ForeignKey('users.id'))
    user_group = Column(String(255), unique=False, nullable=True)
    insta_username = Column(String(555), unique=False, nullable=True)
    insta_post_link = Column(String(555), unique=False,nullable=True)
    created_at = Column(DateTime, default=func.now(), nullable=False) 
    updated_at = Column(DateTime, nullable=True)                      

    user = relationship("User", back_populates="user_links")                        

