from __future__ import with_statement  # If you really need this, keep it at the top
import sys
import os
import telebot
sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
from gina.models import User, UserSubscription, UserLinks
from gina.database import get_session, init_db
from instabot import Bot
from datetime import datetime, timedelta, timezone
import glob
import time
import random

init_db()
session = get_session()

bot = Bot()
credentials = {
    '__stefen_salvatore__': 'aman5911',
    'testeresfera@gmail.com': 'Esferaadmin@123',
    'testexperts84': 'aman5911',
}

# Randomly select a username and password
username = random.choice(list(credentials.keys()))
password = credentials[username]

# Remove existing cookie file if it exists
cookie_del = glob.glob("config/*cookie.json")
for cookie in cookie_del:
    os.remove(cookie)

# Login to Instagram
try:
    bot.login(username=username, password=password)
    time.sleep(random.uniform(1, 3))
    print("Login successful")
except Exception as e:
    if 'challenge_required' in str(e):
        print("Challenge required. Please verify your identity manually.")
    else:
        print(f"Login failed: {e}")
    exit()


def get_latest_post_link():
    print("Fetching latest post links...")
    results = []
    data = session.query(User.name, UserSubscription.insta_username, UserSubscription.type).join(UserSubscription).all()
    print('data',data)
    for all in data:
        print(all)
        name, username, user_type = all
        print(f"Processing user: {username}")

        try:
            print('try')
            user_id = bot.get_user_id_from_username(username)
            media = bot.get_user_medias(user_id, filtration=False)

            if media:
                print("media")
                latest_post_id = media[0]
                latest_post_info = bot.get_media_info(latest_post_id)

                if latest_post_info:
                    print("latest_post_info")
                    latest_post_time = datetime.fromtimestamp(latest_post_info[0]['taken_at']).replace(tzinfo=timezone.utc)
                    six_hours_ago = datetime.now(timezone.utc) - timedelta(hours=6)

                    # Check if the latest post was made in the last 6 hours
                    # if latest_post_time >= six_hours_ago:
                    shortcode = latest_post_info[0]['code']
                    post_link = f"https://www.instagram.com/p/{shortcode}/"
                    print(post_link)

                    get_user = session.query(User).filter(User.name == username).first()

                    if get_user:
                        print("get_user")
                        
                        new_link = UserLinks(
                            user_id=get_user.id,
                            insta_post_link=post_link,
                            insta_username=username,
                            user_group=user_type
                        )
                    else:
                        new_user = User(name=name)
                        session.add(new_user)
                        session.commit()  # Commit to save the new user

                        new_link = UserLinks(
                            user_id=new_user.id,
                            insta_post_link=post_link,
                            insta_username=username,
                            user_group=user_type
                        )

                    session.add(new_link)
                    session.commit()  # Commit to save the new link
                    results.append(post_link)

        except Exception as e:
            print(f"Error processing {username}: {e}")

    return results if results else ["No recent posts found for any user in the last 6 hours."]

# Call the function and print results
latest_posts = get_latest_post_link()
print(latest_posts)
