"""
ASGI config for ignite project.

It exposes the ASGI callable as a module-level variable named ``application``.

For more information on this file, see
https://docs.djangoproject.com/en/4.1/howto/deployment/asgi/
"""

from payments.consumers import PayConsumer
import os

from django.core.asgi import get_asgi_application
from channels.auth import AuthMiddlewareStack
from channels.routing import ProtocolTypeRouter, URLRouter
from django.urls import path
from channels.security.websocket import AllowedHostsOriginValidator
from ignite.custom_auth import TokenAuthMiddleware

os.environ.setdefault("DJANGO_SETTINGS_MODULE", "ignite.settings")

application = ProtocolTypeRouter(
    {
        "http": get_asgi_application(),
        "websocket": 
            TokenAuthMiddleware(URLRouter([
                path('ws/pay/<str:room_name>', PayConsumer.as_asgi()),
            ]))
        ,
    }
)
