from django.db import models
from django.contrib.auth.models import User
from profiles.models import Profile

# Create your models here.


   
class Reaction(models.Model):
    sender = models.ForeignKey(Profile, on_delete=models.CASCADE, related_name="winks_sender", unique=False)
    receiver = models.ForeignKey(Profile, on_delete=models.CASCADE, related_name="winks_receiver", unique=False)
    created_on = models.DateTimeField(auto_now_add=True)
    is_like = models.BooleanField(default=False, blank=False)
    class Meta:
        unique_together=('sender','receiver')
 

class View(models.Model):
    created_on = models.DateTimeField(auto_now_add=True)
    viewer = models.ForeignKey(Profile, related_name="viewed", on_delete=models.CASCADE)
    viewed = models.ForeignKey(Profile, related_name="viewers", on_delete=models.CASCADE)

    class Meta:
        unique_together=['viewer','viewed']



class Match(models.Model):
    participants = models.ManyToManyField(Profile, related_name="participants", unique=False)
    created_on = models.DateTimeField(auto_now_add=True)

