from django.shortcuts import render
from matching.models import Reaction, View
from matching.serializers import RecievedWinkSerializer,WinkSerializer
from matching.throttles import SubscriptionRateThrottle
from profiles.serializers import ProfileSerializer, SimpleProfileSerializer
from rest_framework.decorators import api_view, permission_classes
from rest_framework.permissions import IsAuthenticated
from rest_framework.authtoken.views import ObtainAuthToken
from rest_framework.authtoken.models import Token
from rest_framework.response import Response
from rest_framework import status
from rest_framework.decorators import api_view, permission_classes,throttle_classes
from profiles.models import *
from rest_framework import generics
import datetime as DT
from django.db.models import Q, F
from matching.models import Match
import random
from taggit.models import Tag



# Create your views here.
@api_view(['GET'])
@permission_classes([IsAuthenticated])
def index(request):
    profiles =list(Profile.objects.nearby_locations(
    float(request.user.profile.lat), 
    float(request.user.profile.long)).filter(Q(gender=request.user.profile.looking_for)|Q(looking_for="BOTH")).exclude(user=request.user).all().filter(is_activated=True).all()
    )
  


   
    # return Response(serializer.data)



class ExploreList(generics.ListCreateAPIView):
    permission_classes = [IsAuthenticated]
    def get_queryset(self):
        request = self.request

        # profiles =Profile.objects.nearby_locations(
        # float(request.user.profile.lat), 
        # float(request.user.profile.long)).filter(Q(gender=request.user.profile.looking_for)|Q(looking_for="BOTH")).exclude(user=request.user).exclude(id__in=get_reactions(request.user))
        
      
       
        # print(len(get_reactions(request.user)))
        profiles = Profile.objects.nearby_locations(float(request.user.profile.lat),float(request.user.profile.long)).order_by("-distance").filter(Q(gender=request.user.profile.looking_for)|Q(looking_for="BOTH")).exclude(user_id=request.user.id).exclude(id__in=get_reactions(request.user)).all()
        
        # random.shuffle(profiles)
        return  profiles
    serializer_class = SimpleProfileSerializer
def get_reactions(user)->list:
   winks= Reaction.objects.filter(sender=user.profile)
   return [wink.receiver.id for wink in winks]



# @api_view(['GET'])
@api_view(['GET'])
def get_tags(request):
    tags = Tag.objects.all()
    return Response([tag.name for tag in tags])

@api_view(['GET'])
@throttle_classes([SubscriptionRateThrottle])
def send_wink(request, pk):
    is_match = False
    profile = request.user.profile
    receiver = Profile.objects.get(pk=pk)
    wink = Reaction.objects.create(sender=profile, receiver=receiver, is_like=True)
    rec_winks = Reaction.objects.filter(sender=receiver)
    sent_to = [winked.receiver for winked in rec_winks]
    return Response({
        'id':wink.id
    })


def get_user_views(profile):
    return [view.viewed for view in profile.viewed.all()]


    


@api_view(['GET'])
def revoke_like(request, pk, match_id):
    wink = Reaction.objects.get(pk=pk)
    wink.delete()
    
    return Response(status=status.HTTP_200_OK)

@api_view(['GET'])
def revoke_reaction(request, pk):
    reject = Reaction.objects.get(pk=pk)
    reject.delete()
    return Response(status=status.HTTP_200_OK)


@api_view(['GET'])
def send_reject(request, pk):
    profile = request.user.profile
    receiver = Profile.objects.get(pk=pk)
    reject = Reaction.objects.create(sender=profile, receiver=receiver)
    return Response({
        'reject_id':reject.id
    })



@api_view(['GET'])
def view_profile(request, pk):
    profile = request.user.profile
    viewed = Profile.objects.get(pk=pk)
    # checks if the user had alredy viewd the profile before
    if viewed in get_user_views(profile):
        return Response({
                'profile':ProfileSerializer(instance=viewed,many=False).data
            })
    else:
        # takes all the user subscriptions, thee latest
        subscription = request.user.subscriptions.last()
        print("subs", subscription.items_remaining)
        if subscription.items_remaining>0:
           
            View.objects.create(viewer=profile, viewed=viewed)
            items = subscription.items_used
            subscription.items_used= items+1
            subscription.save()
            print("subs2", subscription.items_remaining)
            return Response({
                'profile':ProfileSerializer(instance=viewed,many=False).data
            })
        else:
            return Response(status=status.HTTP_401_UNAUTHORIZED)
   

class WinkList(generics.ListCreateAPIView):
    # queryset = Reaction.objects.filter(is_like=True)
    def get_queryset(self):
        user = self.request.user
        return [wink.receiver for wink in Reaction.objects.filter(sender=user.profile, is_like=True)]
    serializer_class = SimpleProfileSerializer


class RecievedWinkList(generics.ListCreateAPIView):
    def get_queryset(self):
        user = self.request.user
        return [wink.sender for wink in Reaction.objects.filter(receiver=user.profile, is_like=True)]
    serializer_class = SimpleProfileSerializer

