from datetime import datetime
import json
from asgiref.sync import async_to_sync, sync_to_async
from channels.generic.websocket import WebsocketConsumer, AsyncWebsocketConsumer
from django.contrib.auth.models import User


class PayConsumer(AsyncWebsocketConsumer):
    async def connect(self):
        self.groupname = self.scope['url_route']['kwargs']['room_name']
        self.room_group = f'payments_{self.groupname}'

        await self.channel_layer.group_add(
            self.room_group,
            self.channel_name,
        )
        await self.accept()
        print(self.room_group, 'connected to pay')

    async def disconnect(self, close_code):
        await self.channel_layer.group_discard(
            self.room_group,
            self.channel_name
        )

       

    async def receive(self, text_data):
        text_data_json = json.loads(text_data)
        message = text_data_json['message']

        await self.channel_layer.group_send(
            self.room_group,
            {
                'type': 'chat_message',
                'message': message
            }
        )

    async def chat_message(self, event):
        message = event['message']

        # Send message to WebSocket
        await self.send(text_data=json.dumps({
            'message': message
        }))
