from django.db import models
from django.contrib.auth.models import User
from datetime import datetime

# Create your models here.

class Plan(models.Model):
    type = models.CharField(max_length=100)
    duration = models.DurationField()
    amount = models.PositiveIntegerField()
    description = models.CharField(max_length=200)
    item_count = models.PositiveIntegerField(default=50)
    is_activation = models.BooleanField(default=False)

    def __str__(self) -> str:
        return self.type


# class Featur:
#     likes_count = models.PositiveSmallIntegerField()

#     def __str__(self) -> str:
#         return self.type


class Subscription(models.Model):
    user = models.ForeignKey(User,related_name='subscriptions', on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan, related_name='subscribers', on_delete=models.CASCADE)
    paid_until = models.DateTimeField()
    items_used = models.PositiveIntegerField(default=0)
    

    @property
    def is_active(self):
        return datetime.today<self.paid_until
    
    @property
    def items_remaining(self):
        return self.plan.item_count-self.items_used



class Order(models.Model):
    user = models.ForeignKey(User,related_name='orders', on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan,related_name='orders',on_delete=models.CASCADE, blank=False, max_length=100)
    full_name = models.CharField(max_length=50, blank=False)
    phone_number = models.CharField(max_length=20, blank=False)
    date = models.DateField(auto_now_add=True)
    paid_on = models.DateField(auto_now=True)
    is_paid = models.BooleanField(default=False)
    payment_reference = models.CharField(max_length=100,blank=True)

    @property
    def amount(self):
        self.plan.amount


class Payment(models.Model):
    order = models.ForeignKey(Order, related_name="payments", on_delete=models.CASCADE)
    amount = models.PositiveIntegerField()
    phone_number = models.CharField(max_length=15)
    created = models.DateTimeField(auto_now_add=True)
    reference = models.CharField(max_length=20)


