import json
from django.db.models.signals import post_save
from django.dispatch import receiver
from mpesa.models import PaymentTransaction
from asgiref.sync import async_to_sync
from payments.models import  Order, Payment,Subscription
from datetime import datetime, timedelta
from channels.layers import get_channel_layer





@receiver(post_save, sender=PaymentTransaction)
def updatePayment(sender,created, instance, **kwargs):
    if created:
        return
    order = Order.objects.get(pk=instance.order_id)
   
    if instance.is_successful or instance.trans_id:
        order.is_paid=True
        order.save()
        Payment.objects.create(
            order = order,
            amount= instance.amount,
            phone_number = instance.phone_number,
            reference = instance.pk   
        )

        channel = get_channel_layer()
        group_name = 'payments_{}'.format(instance.pk)
        msg={
            "status":"paid",
            
        }

        async_to_sync(channel.group_send)(
        group_name,
        {
            'type': 'chat_message',
            'message': json.dumps(msg, indent=4, sort_keys=True, default=str)
        }
    )

    
@receiver(post_save, sender=Order)
def update_profile_status(sender,created, instance, **kwargs):
    if created:
        return
    if instance.is_paid:
        plan= instance.plan
        profile = instance.user.profile
        if plan.is_activation:
            profile.is_activated = True
            profile.activation = plan.type.upper()
            profile.save()

        else:
            end_date = datetime.today()+timedelta(days=1)
            Subscription.objects.create(plan=plan,
                                        user = instance.user,
                                        paid_until=end_date)
