from django.shortcuts import render
from rest_framework.permissions import IsAuthenticated
from rest_framework.decorators import api_view, permission_classes
from mpesa.LipaNaMpesaOnline import check_payment_status, sendSTK
from mpesa.models import PaymentTransaction
from payments.models import Plan,Order
from rest_framework.response import Response
from rest_framework import generics
from payments.serializers import OrderSerializer, PlanSerializer
from profiles.serializers import ProfileSerializer
# Create your views here.

@api_view(['POST'])
@permission_classes([IsAuthenticated])
def checkout(request):
    user = request.user
    data = request.data
    plan = Plan.objects.get(pk=data['plan'])
    # phone = ""
    phone = user.username if data['phone'] is None else data['phone']
    order = Order.objects.create(
        user = user,
        plan = plan,
        full_name = user.profile.full_name,
        phone_number = phone

    )
    transaction_id = sendSTK(phone[1:],amount=plan.amount, orderId=order.id)
    return Response({
        'transaction':transaction_id,
        'order':OrderSerializer(order,many=False).data
    })


@api_view(['GET'])
@permission_classes([IsAuthenticated])
def check_payment(request, pk):
    transaction = PaymentTransaction.objects.filter(id=pk).get()
    order = Order.objects.get(pk=transaction.order_id)
    try:
        if transaction.checkout_request_id:
            check_payment_status(transaction.checkout_request_id)
            return Response(
                ProfileSerializer(order.user.profile, many=False).data,
                )
        else:
            return Response({
                "message": "Server Error. Transaction not found",
                "status": False
            }, status=400)
    except PaymentTransaction.DoesNotExist:
            return Response({
                "message": "Server Error. Transaction not found",
                "status": False
            },
                status=400)


class PlanListView(generics.ListAPIView):
    queryset = Plan.objects.filter(is_activation=True)
    serializer_class = PlanSerializer


class SubListView(generics.ListAPIView):
    queryset = Plan.objects.filter(is_activation=False)
    serializer_class = PlanSerializer

