from django.core.management.base import BaseCommand
from faker import Faker
from django.contrib.auth.models import User
from profiles.models import Profile,ProfileImage
import faker.providers
import requests
from django.core.files.images import ImageFile
import os

LOOKING_FOR = [
        'MALE',
        'FEMALE',
        'BOTH',
]
TAGS = [
    'dating',
    'partying',
    'netflix and chill',
    'swimming',
    'dancing',
    'cooking',
    'running',
    'football',
    'exercise',
    'rugby',
    'movies',
    'dining',
    'food',
    'adventure',
    'adrenaline junkie',
    'clubbing',
    'indoor activities',
    'sponsor',
    'road trips',
]

GENDER = [
   "MALE",
   "FEMALE",
   
]


class Provider(faker.providers.BaseProvider):
    def gender(self):
        return self.random_element(GENDER)

    def looking(self):
        return self.random_element(LOOKING_FOR)

    def tags(self):
        return self.random_choices(TAGS)



class Command(BaseCommand):
    help = "generate fake user profiles"

    def add_arguments(self, parser):
        parser.add_argument('total', type=int, help='Indicates the number of users to be created')


    def handle(self, *args, **kwargs):
        total = kwargs['total']

        fake = Faker()
        fake.add_provider(Provider)
        users =[]
        profiles = []
        for _ in range(total):
            user = User.objects.create_user(
                username=fake.unique.phone_number(),
                password=fake.text(max_nb_chars=20)
            )
            # users.append(user)

            profile = user.profile
            profile.bio = fake.text(max_nb_chars=250)
            profile.full_name = fake.name()
            profile.gender = fake.gender()
            profile.looking_for = fake.looking()
            profile.location = fake.city()
            profile.country = fake.country()
            profile.lat = fake.latitude()
            profile.long = fake.longitude()
            profile.tags.add(*fake.tags())
            profile.birth_date = fake.date()
            profile.save()

            for _ in range(2):

                url = fake.image_url(width=400,height=400)
                s = requests.get(url)
                sname = f"{fake.word()}.png"
                with open(sname, 'wb') as f:
                    f.write(s.content)


                ProfileImage.objects.create(
                    user = profile,
                    image = ImageFile(open(sname, "rb"))
                )

                os.remove(sname)
            
       
        
            
        