# Generated by Django 3.2.5 on 2023-01-05 09:39

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import profiles.models
import taggit.managers


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('taggit', '0004_alter_taggeditem_content_type_alter_taggeditem_tag'),
    ]

    operations = [
        migrations.CreateModel(
            name='Profile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('bio', models.TextField(default='', max_length=500)),
                ('gender', models.CharField(choices=[('MALE', 'Male'), ('FEMALE', 'Female')], default='MALE', max_length=6)),
                ('activation', models.CharField(choices=[('STARTER', 'starter'), ('BETA', 'beta'), ('ALPHA', 'alpha')], default='STARTER', max_length=8)),
                ('phone', models.CharField(max_length=15)),
                ('full_name', models.CharField(max_length=15)),
                ('hair_length', models.CharField(choices=[('LONG', 'Long'), ('SHOULDER LENGTH', 'Shoulder Length'), ('AVERAGE', 'Average'), ('SHORT', 'Short'), ('SHAVED', 'Shaved')], default='LONG', max_length=100)),
                ('ethnicity', models.CharField(choices=[('WHITE', 'White'), ('ASIAN: INDIAN', 'Asian: Indian'), ('ASIAN: PAKISTANI', 'Asian: Pakistani'), ('ASIAN: BANGLADESHI', 'Asian: Bangladeshi'), ('ASIAN: CHINESE', 'Asian: Chinese'), ('BLACK', 'Black'), ('MIXED', 'Mixed'), ('OTHER ETHNICITY', 'Other Ethnicity')], default='WHITE', max_length=100)),
                ('relationship_status', models.CharField(choices=[('NEVER MARRIED', 'Never Married'), ('DIVORCED', 'Divorced'), ('WIDOWED', 'Widowed'), ('SEPARATED', 'Separated')], default='NEVER MARRIED', max_length=100)),
                ('education', models.CharField(choices=[('HIGH SCHOOL', 'High School'), ('COLLEGE', 'College'), ('BACHELORS DEGREE', 'Bachelors Degree'), ('MASTERS', 'Masters'), ('PHD / POST DOCTORAL', 'PhD / Post Doctoral')], default='HIGH SCHOOL', max_length=100)),
                ('height', models.DecimalField(decimal_places=2, default=180.34, max_digits=10)),
                ('hair_colour', models.CharField(choices=[('BLACK', 'Black'), ('BLONDE', 'Blonde'), ('BROWN', 'Brown'), ('RED', 'Red'), ('GREY', 'Grey'), ('BALD', 'Bald'), ('BLUE', 'Blue'), ('PINK', 'Pink'), ('GREEN', 'Green'), ('PURPLE', 'Purple'), ('OTHER', 'Other')], default='BLACK', max_length=10)),
                ('body_type', models.CharField(choices=[('THIN', 'Thin'), ('AVERAGE', 'Average'), ('FIT', 'Fit'), ('MUSCULAR', 'Muscular'), ('A LITTLE EXTRA', 'A Little Extra'), ('CURVY', 'Curvy')], default='AVERAGE', max_length=15)),
                ('looking_for', models.CharField(choices=[('MALE', 'Men'), ('FEMALE', 'Women'), ('BOTH', 'Both')], default='BOTH', max_length=6)),
                ('children', models.BooleanField(default=False)),
                ('country', models.CharField(default='', max_length=100)),
                ('location', models.CharField(default='', max_length=100)),
                ('lat', models.DecimalField(decimal_places=6, default='-2.0180319', max_digits=9)),
                ('long', models.DecimalField(decimal_places=6, default='52.5525525', max_digits=9)),
                ('birth_date', models.DateField(blank=True, default=datetime.date(1990, 1, 1), null=True)),
                ('is_premium', models.BooleanField(default=False)),
                ('is_complete', models.BooleanField(default=False)),
                ('is_activated', models.BooleanField(default=False)),
                ('is_verified', models.CharField(choices=[('TO BE APPROVED', 'To be approved'), ('APPROVED', 'Approved'), ('NOT APPROVED', 'Not approved')], default='TO BE APPROVED', max_length=14)),
                ('tags', taggit.managers.TaggableManager(blank=True, help_text='A comma-separated list of tags.', through='taggit.TaggedItem', to='taggit.Tag', verbose_name='Tags')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ProfileImage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(blank=True, upload_to=profiles.models.image_filename)),
                ('is_verified', models.CharField(choices=[('TO BE APPROVED', 'To be approved'), ('APPROVED', 'Approved'), ('NOT APPROVED', 'Not approved')], default='TO BE APPROVED', max_length=14)),
                ('user', models.ForeignKey(default=None, on_delete=django.db.models.deletion.CASCADE, related_name='images', to='profiles.profile')),
            ],
        ),
    ]
