from rest_framework import serializers
from profiles.models import Profile, ProfileImage
from taggit.serializers import (TagListSerializerField,
                                TaggitSerializer)



class ImageSerializer(serializers.ModelSerializer):
    class Meta:
        model=ProfileImage
        fields = ['image']

class ProfileSerializer(TaggitSerializer,serializers.ModelSerializer):
    tags = TagListSerializerField()
    images = ImageSerializer(many=True)
    age = serializers.ReadOnlyField()
    
    class Meta:
        model=Profile
        exclude=['birth_date']


class SimpleProfileSerializer(serializers.ModelSerializer):
    tags = TagListSerializerField()
    images = ImageSerializer(many=True, read_only=True)
    age = serializers.ReadOnlyField()
    distance=serializers.ReadOnlyField()
    class Meta:
        model=Profile
        fields = ['id','full_name','age','tags','images','phone','location','distance']