from django.shortcuts import render
from profiles.serializers import ProfileSerializer, SimpleProfileSerializer
from rest_framework.decorators import api_view, permission_classes
from rest_framework.permissions import IsAuthenticated
from rest_framework.authtoken.views import ObtainAuthToken
from rest_framework.authtoken.models import Token
from rest_framework.response import Response
from rest_framework import status
from profiles.models import *
from rest_framework import generics
import datetime as DT
from django.db.models import Q, F

# Create your views here.

@api_view(['GET'])
@permission_classes([IsAuthenticated])
def getCurrentUser(request):
    user =request.user
    profile = Profile.objects.get(user=user)
    ser = ProfileSerializer(profile,many=False)
    
    return Response(ser.data)

@api_view(['POST'])
@permission_classes([IsAuthenticated])
def add_image(request):
    user = request.user
    profile = Profile.objects.get(user=user)
    image = request.FILES.get('image')
    ProfileImage.objects.create(
        user=profile,
        image=image
    )
    return Response({'data':'ok'})

@api_view(['PUT'])
@permission_classes([IsAuthenticated])
def update_profile(request):
    data = request.data
    print(data['birth_date'])
    profile = request.user.profile
    profile.full_name = data['full_name']
    profile.lat = data['lat']
    profile.country = data['country']
    profile.long = data['long']
    profile.gender = data['gender']
    profile.looking_for = data['looking_for']
    profile.birth_date =DT.datetime.strptime(data['birth_date'], '%Y-%m-%d') 
    profile.location = data['location']
    profile.is_complete = data['is_complete']
    profile.bio = data['bio']
    profile.tags.add(*data['tags'])
    profile.save()
    return Response(ProfileSerializer(profile,many=False).data)
    















class ProfileList(generics.RetrieveUpdateAPIView):
    queryset = Profile.objects.all()
    serializer_class = ProfileSerializer




