from django.shortcuts import redirect
from functools import wraps

def admin_login_required(view_func):
    @wraps(view_func)
    def wrapper(request, *args, **kwargs):
        if not request.session.get('admin_id'):
            return redirect('/admin-login')
        return view_func(request, *args, **kwargs)
    return wrapper
