from django import forms
from admin_panel.models import *

class AdminSigninForm(forms.Form):
    email = forms.CharField(required=True)
    password =  forms.CharField(required=True)

class AdminRegisterForm(forms.Form):
    username = forms.CharField(required=True)
    email = forms.EmailField(required=True)
    password = forms.CharField(widget=forms.PasswordInput, required=True)
    confirm_password = forms.CharField(widget=forms.PasswordInput, required=True)

    def clean(self):
        cleaned_data = super().clean()
        password = cleaned_data.get('password')
        confirm_password = cleaned_data.get('confirm_password')

        if password != confirm_password:
            raise forms.ValidationError("Passwords do not match")
        return cleaned_data


class AdminForgetPasswordForm(forms.Form):
    email = forms.CharField(required=True)

class ForgetVerificationForm(forms.Form):
    new_password = forms.CharField(max_length=35,required=True)
    confirm_new_password = forms.CharField(max_length=35,required=True)

class AdminProfileForm(forms.Form):
    first_name = forms.CharField(required=True)
    last_name = forms.CharField(required=True)
    email = forms.CharField(required=True)
    phone_number = forms.CharField(required=True)
    address = forms.CharField(required=True)


class ChangePasswordForm(forms.Form):
    old_password    = forms.CharField(max_length=35, required=True)
    password        = forms.CharField(max_length=35, required=True)
    confirmPassword = forms.CharField(max_length=35, required=True)


class UserChangePasswordForm(forms.Form):
    password        = forms.CharField(max_length=35, required=True)
    confirmPassword = forms.CharField(max_length=35, required=True)