from django.db import models
from django.contrib.auth.models import User
# Create your models here.

class SuperAdmin(models.Model):
    user = models.ForeignKey(User,on_delete=models.CASCADE)
    email = models.CharField(max_length=54,null=True)
    firstName = models.CharField(max_length=100,null=True)
    lastName = models.CharField(max_length=100,null=True)
    image = models.CharField(max_length=100,null= True)
    gender = models.CharField(max_length=10,null=True)
    address = models.TextField(null= True)
    password = models.CharField(max_length=250,default='',null=True)
    phoneNumber = models.CharField(max_length=100,null=True)
    forgotPasswordLink = models.CharField(max_length=254,null=True)
    is_subadmin = models.BooleanField(default=False,null=True)
    role = models.IntegerField(max_length=10,null=True)
    role_name = models.CharField(max_length=254,null=True)
    created_at=models.DateTimeField(auto_now_add=True)
    updated_at=models.DateTimeField(auto_now=True)
    end_date = models.DateTimeField(null=True)

    class Meta:
        db_table = "super_admin"