from django.views.generic import TemplateView
from django.http import HttpResponseRedirect
from django.shortcuts import render, redirect
from . import forms
from django.contrib.auth import authenticate, login, logout
from django.contrib import messages
from .models import SuperAdmin
import math, random, string
from django.template.loader import render_to_string
from django.core import mail
from django.conf import settings
from calls.models import *
from .forms import AdminRegisterForm, AdminSigninForm, AdminForgetPasswordForm, ForgetVerificationForm
from django.shortcuts import render, redirect
from django.views.generic import TemplateView
from django.contrib import messages
from django.contrib.auth.hashers import check_password, make_password
from .forms import AdminSigninForm
from .models import SuperAdmin
from django.contrib.auth.decorators import user_passes_test
from django.contrib.auth import login as auth_login
from django.views.decorators.cache import never_cache

from django.utils.crypto import get_random_string
from django.core.mail import send_mail
from django.contrib import messages
from django.shortcuts import render, redirect

from django.shortcuts import redirect
from functools import wraps

# def admin_login_required(view_func):
#     @wraps(view_func)
#     def wrapper(request, *args, **kwargs):
#         if not request.session.get('admin_id'):
#             return redirect('/admin-login')
#         return view_func(request, *args, **kwargs)
#     return wrapper
def admin_login_required(view_func):
    @wraps(view_func)
    def wrapper(request, *args, **kwargs):
        if not request.session.get('admin_id'):
            messages.error(request, "Please log in to access this page.")
            return redirect('/admin-login')
        return view_func(request, *args, **kwargs)
    return wrapper
class AdminLogIn(TemplateView):
    template_name = 'admin-signup.html'

    def get(self, request):
        return render(request, self.template_name, {'form': AdminSigninForm()})

    def post(self, request):
        form = AdminSigninForm(request.POST)
        if form.is_valid():
            email = form.cleaned_data.get('email')
            password = form.cleaned_data.get('password')

            try:
                super_admin = SuperAdmin.objects.get(email=email)
            except SuperAdmin.DoesNotExist:
                messages.error(request, "Email not found.")
                return render(request, self.template_name, {'form': form})

            if check_password(password, super_admin.password):
                request.session['admin_id'] = super_admin.id
                messages.success(request, "Login successful!", extra_tags="login")
                return redirect('/adminprofile')

            else:
                messages.error(request, "Invalid password.")
        else:
            messages.error(request, "Invalid form submission.")

        return render(request, self.template_name, {'form': form})

# @never_cache
@admin_login_required
def admin_logout(request):
    # Flush session to remove all admin data
    request.session.flush()
    messages.success(request, "Logged out successfully.", extra_tags="logout")
    return redirect('/admin-login')


from django.core.paginator import Paginator
from django.shortcuts import render
@never_cache
@admin_login_required
def admin_dashboard(request):
    admin = SuperAdmin.objects.first()  
    view = request.GET.get('view', 'conversations') 

    messages_qs = ConversationMessage.objects.all().order_by('-call_started_at')
    paginator = Paginator(messages_qs, 10)
    page_number = request.GET.get('page')
    page_obj = paginator.get_page(page_number)

    return render(request, 'admin-dashboard.html', {
        'admin': admin,
        'view': view,
        'messages': page_obj
    })
@never_cache
@admin_login_required
def change_password(request):
    admin_id = request.session.get('admin_id')
    try:
        admin = SuperAdmin.objects.get(id=admin_id)
    except SuperAdmin.DoesNotExist:
        messages.error(request, "Admin not found!")
        return redirect('/admin-login')

    if request.method == 'POST':
        current_password = request.POST.get('current_password')
        new_password = request.POST.get('new_password')
        confirm_password = request.POST.get('confirm_password')

        if not check_password(current_password, admin.password):
            messages.error(request, "Current password is incorrect.")
            return redirect('/change-password')

        if new_password != confirm_password:
            messages.error(request, "New passwords do not match.")
            return redirect('/change-password')

        admin.password = make_password(new_password)
        admin.save()

        messages.success(request, "Password changed successfully!")
        return redirect('/?view=profile')

    return render(request, 'change-password.html')


def forgot_password(request):
    if request.method == "POST":
        email = request.POST.get("email")
        try:
            user = SuperAdmin.objects.get(email=email)

            otp = get_random_string(length=6, allowed_chars='0123456789')

    
            request.session['reset_otp'] = otp
            request.session['reset_email'] = email

            # Send email
            send_mail(
                "Password Reset OTP",
                f"Hello {user.firstName},\n\nYour OTP for password reset is: {otp}\n\nThis code will expire in 10 minutes.",
                "contact@nudgeworld.io",
                [email],
                fail_silently=False,
            )

            messages.success(request, "An OTP has been sent to your email.")
            return redirect("verify-otp")

        except SuperAdmin.DoesNotExist:
            messages.error(request, "No account found with this email.")
            return redirect("forgot-password")

    return render(request, "forgot-password.html")


# @admin_login_required
def verify_otp(request):
    if request.method == "POST":
        entered_otp = request.POST.get("otp")
        session_otp = request.session.get("reset_otp")
        session_email = request.session.get("reset_email")

        if not session_email:
            messages.error(request, "Session expired. Try again.")
            return redirect("forgot-password")

        if entered_otp == session_otp:
            return redirect("admin-dashboard")

        messages.error(request, "Invalid OTP. Please try again.")
        return redirect("verify-otp")

    return render(request, "verify-otp.html")




from django.core.paginator import Paginator

@never_cache
@admin_login_required
def conversations_page(request):
    messages_qs = ConversationMessage.objects.all().order_by('-call_started_at')
    paginator = Paginator(messages_qs, 10)
    page_number = request.GET.get('page')
    page_obj = paginator.get_page(page_number)

    return render(request, 'conversations.html', {
        'messages': page_obj
    })

@never_cache
@admin_login_required
def summary_page(request):
    messages_qs = ConversationMessage.objects.all().order_by('-call_started_at')
    paginator = Paginator(messages_qs, 10)
    page_number = request.GET.get('page')
    page_obj = paginator.get_page(page_number)

    return render(request, 'summary.html', {
        'messages': page_obj
    })


from django.shortcuts import render, redirect
from .models import SuperAdmin
# your session-check decorator

@never_cache
@admin_login_required
def admin_profile(request):
    admin_id = request.session.get('admin_id')
    try:
        admin = SuperAdmin.objects.get(id=admin_id)
    except SuperAdmin.DoesNotExist:
        return redirect('/admin-login')

    return render(request, 'admin-profile.html', {'admin': admin})
