from django.contrib import admin
from .models import conversation


@admin.register(conversation)
class ConversationAdmin(admin.ModelAdmin):
    list_display = ('call_id', 'phone_number', 'direction', 'status', 'started_at', 'has_summary', 'sentiment', 'outcome')
    list_filter = ('status', 'direction', 'sentiment', 'outcome', 'started_at')
    search_fields = ('phone_number', 'call_id', 'summary', 'transcript')
    readonly_fields = ('id', 'created_at', 'updated_at')
    fieldsets = (
        ('Call Information', {
            'fields': ('id', 'call_id', 'phone_number', 'direction', 'status')
        }),
        ('Timing', {
            'fields': ('started_at', 'ended_at', 'duration_seconds')
        }),
        ('Content', {
            'fields': ('transcript', 'summary', 'sentiment', 'outcome', 'recording_url')
        }),
        ('Metadata', {
            'fields': ('meta_data',)
        }),
        ('Timestamps', {
            'fields': ('created_at', 'updated_at')
        }),
    )
    
    def has_summary(self, obj):
        return bool(obj.summary)
    has_summary.boolean = True
    has_summary.short_description = 'Has Summary'
