import uuid
import json
from django.db import models
from django.utils import timezone


class FlexibleJSONField(models.JSONField):
    """JSONField that handles both string and dict values from database"""
    def from_db_value(self, value, expression, connection):
        if value is None:
            return value
        # If value is already a dict/list, return it as-is (PostgreSQL JSONB)
        if isinstance(value, (dict, list)):
            return value
        # If value is a string, parse it
        if isinstance(value, str):
            try:
                return json.loads(value)
            except json.JSONDecodeError:
                return value
        return value


class conversation(models.Model):
    call_id = models.CharField(max_length=255, unique=True, null=False, db_index=True)
    phone_number = models.CharField(max_length=50, null=False, db_index=True)
    direction = models.CharField(max_length=20, null=False)
    status = models.CharField(max_length=50, null=False, default="initiated")
    started_at = models.DateTimeField(default=timezone.now, db_index=True)
    ended_at = models.DateTimeField(null=True, blank=True)
    duration_seconds = models.IntegerField(null=True, blank=True)
    transcript = models.TextField(null=True, blank=True)
    summary = models.TextField(null=True, blank=True)
    sentiment = models.CharField(max_length=20, null=True, blank=True)
    outcome = models.CharField(max_length=50, null=True, blank=True)
    recording_url = models.TextField(null=True, blank=True)
    meta_data = FlexibleJSONField(default=dict, blank=True, db_column='metadata')  # Column name in DB is 'metadata'
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    class Meta:
        db_table = 'conversations'

 # Use your correct import here

class ConversationMessage(models.Model):

    timestamp = models.CharField(max_length=255, primary_key=True,unique=True, null=False, db_index=True)
    call_recording_url = models.CharField(max_length=255, null=False, db_index=True)
    call_transcript = models.TextField(null=False)
    call_summary = models.TextField(null=False, default="initiated")
    call_duration_seconds = models.IntegerField(null=True, blank=True)
    # call_cost = models.DecimalField(max_digits=10, decimal_places=2, null=True, blank=True)
    call_status = models.IntegerField(null=True, blank=True)
    vapi_call_id = models.TextField(null=True, blank=True)
    call_started_at = models.DateTimeField(null=True, blank=True)
    call_ended_at = models.DateTimeField(null=True, blank=True)
    phone_number = models.CharField(max_length=50, null=True, blank=True)
    client_status = models.TextField(null=True, blank=True)
    # qualification_status = FlexibleJSONField(default=dict, blank=True)
    last_updated = models.DateTimeField(auto_now=True)
    mondayItemId = models.CharField(max_length=255, null=True, blank=True)
    # Schedule_Meeting = models.CharField(max_length=100, null=True, blank=True)
    LeadId = models.CharField(max_length=100, null=True, blank=True)
    lead_name = models.CharField(max_length=255, null=True, blank=True)
    lead_email = models.EmailField(null=True, blank=True)
    primaryPhone = models.CharField(max_length=50, null=True, blank=True)
    secondaryPhone =models.CharField(max_length=50, null=True, blank=True)

    class Meta:
        db_table = 'conversation_messages'


class EndUser(models.Model):
	enduser_id  = models.CharField(max_length=20,default='',null=True)
	name = models.CharField(max_length=244,default='')
	email = models.EmailField(max_length=100,null=True)
	gender = models.CharField(max_length=30,default='',null=True)
	email_verification_otp = models.IntegerField(null=True)
	email_verified = models.BooleanField(default=False)
	phone_number = models.CharField(max_length=20, default='',null=True)
	phone_number_otp = models.CharField(max_length=20, default='',null=True)
	phone_number_verified = models.BooleanField(default=False)
	password = models.CharField(max_length=250,default='',null=True)
	forgot_password_otp = models.IntegerField(null=True)
	image = models.TextField(null=True)
	status =  models.BooleanField(default=True)
	created_at = models.DateTimeField(auto_now_add=True)
	last_login = models.DateTimeField(null=True, blank=True)
	updated_at = models.DateTimeField(auto_now=True)
	end_date = models.DateTimeField(null=True) 

	class Meta:
		db_table = 'end_User'
