from django.db import models

# Create your models here.


class ProductSample(models.Model):
    product_line = models.CharField(max_length=100,null=True)
    subfamily = models.CharField(max_length=100,null=True)
    tm_article_number = models.CharField(max_length=50,null=True)
    style_name = models.CharField(max_length=200,null=True)
    og_style_name = models.CharField(max_length=200,null=True)
    color_name = models.CharField(max_length=100,null=True)
    season = models.CharField(max_length=20,null=True)
    par_date = models.CharField(max_length=100,null=True)
    number_of_samples_received = models.CharField(max_length=100,null=True, blank=True)
    marketing_sample_estimated_date = models.CharField(max_length=100,null=True)
    rep_sms_photoshop_comments = models.TextField(null=True, blank=True)
    location = models.CharField(max_length=200, null=True, blank=True)
    sample_pass_off_date = models.CharField(max_length=100,null=True)
    lionshead_received_date = models.CharField(max_length=100,null=True)
    flatlay_shoot_date = models.CharField(max_length=100,null=True)
    flatlay_shoot = models.CharField(max_length=5, null=True, blank=True)  # Y or N
    on_model_shoot_date = models.CharField(max_length=100,null=True)
    on_models_shot = models.CharField(max_length=5, null=True, blank=True)  # Y or N
    sample_return_date = models.CharField(max_length=100,null=True)
    last_updated_datetime = models.CharField(max_length=100, null=True, blank=True)
    updated_by = models.CharField(max_length=100, null=True, blank=True)

    class Meta:
        db_table = 'product_sample'
