from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework import status
import random
from datetime import datetime,date,timedelta
from django.conf import settings
from passlib.hash import django_pbkdf2_sha256 as handler
import json
from rest_framework.authentication import get_authorization_header
from rest_framework_simplejwt.tokens import RefreshToken
from rest_framework_simplejwt.backends import TokenBackend
from rest_framework import exceptions
from django.shortcuts import render, redirect,HttpResponse
from django.core import mail
from django.template.loader import render_to_string
import math, random, string
from django.contrib import messages
from django.utils.timesince import timesince
from django.db.models import Max
from django.db.models import Q
from django.core.files.storage import FileSystemStorage
from django.views.generic import TemplateView
from django.core.mail import send_mail
from django.db import transaction
from datetime import datetime, timedelta
from .models import ProductSample
from .serializers import ProductSampleSerializer
import pandas as pd

# Create your views here.



class getProductListing(APIView):
    def get(self, request):
        samples = ProductSample.objects.all()
        serializer = ProductSampleSerializer(samples, many=True)
        return Response(serializer.data)
    
    
class uploadProductSample(APIView):
    def post(self, request, format=None):
        file = request.FILES.get('file')

        if not file:
            return Response({'error': 'No file uploaded'}, status=status.HTTP_400_BAD_REQUEST)

        try:
            if file.name.endswith('.csv'):
                df = pd.read_csv(file)
            elif file.name.endswith('.xlsx'):
                df = pd.read_excel(file)
            else:
                return Response({'error': 'Unsupported file format'}, status=status.HTTP_400_BAD_REQUEST)
        except Exception as e:
            return Response({'error': f'Error reading file: {str(e)}'}, status=status.HTTP_400_BAD_REQUEST)

        for _, row in df.iterrows():
            ProductSample.objects.create(
                product_line=row.get('PRODUCT LINE'),
                subfamily=row.get('SUBFAMILY'),
                tm_article_number=row.get('TM ARTICLE NUMBER'),
                style_name=row.get('STYLE NAME'),
                og_style_name=row.get('OG STYLE NAME'),
                color_name=row.get('COLOR  NAME'),
                season=row.get('SEASON'),
                par_date=row.get('PAR Date'),
                number_of_samples_received=row.get('Number of Samples Received') or None,
                marketing_sample_estimated_date=row.get('Marketing Sample Estimated Date'),
                rep_sms_photoshop_comments=row.get('Rep SMS/Photoshop Comments'),
                location=row.get('LOCATION'),
                sample_pass_off_date=row.get('Sample Pass off Date'),
                lionshead_received_date=row.get('Lionshead Received Date'),
                flatlay_shoot_date=row.get('Flatlay Shoot Date'),
                flatlay_shoot=row.get('Flatlays Shot (Y or N)'),
                on_model_shoot_date=row.get('On Model Shoot Date'),
                on_models_shot=row.get('On Models Shot (Y or N)'),
                sample_return_date=row.get('Sample Return Date'),
                last_updated_datetime=row.get('Last Updated DateTime'),
                updated_by=row.get('Updated By'),
            )

        return Response({'message': 'File uploaded and data saved successfully!'}, status=status.HTTP_201_CREATED)
    
    
class GetProductDetail(APIView):
    def post(self, request):
        article_number = request.data.get('article_number')

        if not article_number:
            return Response({'error': 'article_number is required'}, status=status.HTTP_400_BAD_REQUEST)

        try:
            product = ProductSample.objects.get(tm_article_number=article_number)
        except ProductSample.DoesNotExist:
            return Response({'error': 'Product not found'}, status=status.HTTP_404_NOT_FOUND)

        serializer = ProductSampleSerializer(product)
        return Response(serializer.data, status=status.HTTP_200_OK)