from django.contrib import admin
from .models import Call, CallLog


@admin.register(Call)
class CallAdmin(admin.ModelAdmin):
    list_display = ['senior', 'twilio_status', 'duration', 'created_at', 'initiated_by']
    list_filter = ['twilio_status', 'vapi_status', 'created_at', 'call_purpose']
    search_fields = ['senior__name', 'twilio_sid', 'vapi_call_id']
    readonly_fields = ['created_at', 'updated_at']
    
    fieldsets = (
        ('Call Information', {
            'fields': ('senior', 'call_purpose', 'initiated_by')
        }),
        ('Twilio Details', {
            'fields': ('twilio_sid', 'twilio_status', 'duration', 'call_start_time', 'call_end_time')
        }),
        ('Vapi Details', {
            'fields': ('vapi_call_id', 'vapi_status')
        }),
        ('AI Configuration', {
            'fields': ('ai_prompt',),
            'classes': ('collapse',)
        }),
        ('Timestamps', {
            'fields': ('created_at', 'updated_at'),
            'classes': ('collapse',)
        }),
    )


@admin.register(CallLog)
class CallLogAdmin(admin.ModelAdmin):
    list_display = ['call', 'event_type', 'message', 'created_at']
    list_filter = ['event_type', 'created_at']
    search_fields = ['call__senior__name', 'message']
    readonly_fields = ['created_at']
    
    fieldsets = (
        ('Log Information', {
            'fields': ('call', 'event_type', 'message')
        }),
        ('Additional Data', {
            'fields': ('data',),
            'classes': ('collapse',)
        }),
        ('Timestamp', {
            'fields': ('created_at',)
        }),
    )