from django.core.management.base import BaseCommand
from calls.tasks import check_and_update_call_statuses


class Command(BaseCommand):
    help = 'Check and update call statuses from Vapi.ai'

    def add_arguments(self, parser):
        parser.add_argument(
            '--dry-run',
            action='store_true',
            help='Show what would be updated without actually updating',
        )

    def handle(self, *args, **options):
        if options['dry_run']:
            self.stdout.write(
                self.style.WARNING('Dry run mode - would check Vapi.ai for call statuses')
            )
            return

        self.stdout.write('Checking call statuses from Vapi.ai...')
        
        result = check_and_update_call_statuses()
        
        if result['status'] == 'success':
            updated_count = result['updated_count']
            self.stdout.write(
                self.style.SUCCESS(f'Successfully updated {updated_count} call statuses')
            )
        else:
            self.stdout.write(
                self.style.ERROR(f'Error updating call statuses: {result["message"]}')
            )
