from django.contrib import admin
from .models import Conversation, Memory, ConversationInsight


@admin.register(Conversation)
class ConversationAdmin(admin.ModelAdmin):
    list_display = ['call', 'sentiment_score', 'engagement_level', 'created_at']
    list_filter = ['engagement_level', 'created_at']
    search_fields = ['call__senior__name', 'summary']
    readonly_fields = ['created_at', 'updated_at']
    
    fieldsets = (
        ('Conversation', {
            'fields': ('call', 'transcript', 'summary')
        }),
        ('Analysis', {
            'fields': ('topics_discussed', 'key_memories', 'emotions_detected', 'sentiment_score', 'engagement_level')
        }),
        ('Follow-up', {
            'fields': ('follow_up_topics', 'follow_up_questions')
        }),
        ('Timestamps', {
            'fields': ('created_at', 'updated_at'),
            'classes': ('collapse',)
        }),
    )


@admin.register(Memory)
class MemoryAdmin(admin.ModelAdmin):
    list_display = ['title', 'senior', 'memory_type', 'importance_score', 'times_referenced', 'created_at']
    list_filter = ['memory_type', 'created_at', 'importance_score']
    search_fields = ['title', 'content', 'senior__name']
    readonly_fields = ['times_referenced', 'last_referenced', 'created_at', 'updated_at']
    
    fieldsets = (
        ('Memory Information', {
            'fields': ('senior', 'conversation', 'memory_type', 'title', 'content')
        }),
        ('Metadata', {
            'fields': ('importance_score', 'tags')
        }),
        ('Usage Tracking', {
            'fields': ('times_referenced', 'last_referenced')
        }),
        ('Timestamps', {
            'fields': ('created_at', 'updated_at'),
            'classes': ('collapse',)
        }),
    )


@admin.register(ConversationInsight)
class ConversationInsightAdmin(admin.ModelAdmin):
    list_display = ['title', 'senior', 'insight_type', 'confidence_score', 'created_at']
    list_filter = ['insight_type', 'created_at', 'confidence_score']
    search_fields = ['title', 'description', 'senior__name']
    readonly_fields = ['created_at', 'updated_at']
    
    fieldsets = (
        ('Insight Information', {
            'fields': ('senior', 'insight_type', 'title', 'description')
        }),
        ('Analysis Data', {
            'fields': ('data', 'confidence_score')
        }),
        ('Timestamps', {
            'fields': ('created_at', 'updated_at'),
            'classes': ('collapse',)
        }),
    )