# Generated by Django 5.2.7 on 2025-10-13 06:13

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('calls', '0001_initial'),
        ('seniors', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Conversation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('transcript', models.TextField(blank=True, help_text='Full transcript of the conversation')),
                ('summary', models.TextField(blank=True, help_text='AI-generated summary of the conversation')),
                ('topics_discussed', models.JSONField(default=list, help_text='List of topics discussed during the conversation')),
                ('key_memories', models.JSONField(default=list, help_text='Key memories or stories shared during the conversation')),
                ('emotions_detected', models.JSONField(default=list, help_text='Emotions detected during the conversation')),
                ('sentiment_score', models.FloatField(blank=True, help_text='Overall sentiment score (-1 to 1)', null=True)),
                ('engagement_level', models.CharField(blank=True, choices=[('low', 'Low'), ('medium', 'Medium'), ('high', 'High')], help_text='Level of engagement during the conversation', max_length=20, null=True)),
                ('follow_up_topics', models.JSONField(default=list, help_text='Topics to discuss in future calls')),
                ('follow_up_questions', models.JSONField(default=list, help_text='Questions to ask in future calls')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('call', models.OneToOneField(help_text='The call this conversation belongs to', on_delete=django.db.models.deletion.CASCADE, related_name='conversation', to='calls.call')),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='ConversationInsight',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('insight_type', models.CharField(choices=[('mood_trend', 'Mood Trend'), ('interest_change', 'Interest Change'), ('health_concern', 'Health Concern'), ('social_pattern', 'Social Pattern'), ('memory_pattern', 'Memory Pattern'), ('communication_style', 'Communication Style')], help_text='Type of insight', max_length=20)),
                ('title', models.CharField(help_text='Title of the insight', max_length=200)),
                ('description', models.TextField(help_text='Description of the insight')),
                ('data', models.JSONField(default=dict, help_text='Supporting data for the insight')),
                ('confidence_score', models.FloatField(default=0.5, help_text='Confidence score (0-1) for the insight')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('senior', models.ForeignKey(help_text='The senior this insight belongs to', on_delete=django.db.models.deletion.CASCADE, related_name='insights', to='seniors.senior')),
            ],
            options={
                'ordering': ['-confidence_score', '-created_at'],
            },
        ),
        migrations.CreateModel(
            name='Memory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('memory_type', models.CharField(choices=[('story', 'Story'), ('fact', 'Fact'), ('preference', 'Preference'), ('relationship', 'Relationship'), ('experience', 'Experience'), ('achievement', 'Achievement')], help_text='Type of memory', max_length=20)),
                ('title', models.CharField(help_text='Short title for the memory', max_length=200)),
                ('content', models.TextField(help_text='The memory content')),
                ('importance_score', models.FloatField(default=0.5, help_text='Importance score (0-1) for prioritizing memories')),
                ('tags', models.JSONField(default=list, help_text='Tags for categorizing the memory')),
                ('times_referenced', models.PositiveIntegerField(default=0, help_text='Number of times this memory has been referenced in conversations')),
                ('last_referenced', models.DateTimeField(blank=True, help_text='When this memory was last referenced', null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('conversation', models.ForeignKey(help_text='The conversation this memory was extracted from', on_delete=django.db.models.deletion.CASCADE, related_name='memories', to='conversations.conversation')),
                ('senior', models.ForeignKey(help_text='The senior this memory belongs to', on_delete=django.db.models.deletion.CASCADE, related_name='memories', to='seniors.senior')),
            ],
            options={
                'ordering': ['-importance_score', '-created_at'],
                'unique_together': {('senior', 'title')},
            },
        ),
    ]
