from django.contrib import admin
from .models import Senior


@admin.register(Senior)
class SeniorAdmin(admin.ModelAdmin):
    list_display = ['name', 'phone_number', 'age', 'caregiver', 'is_active', 'created_at']
    list_filter = ['is_active', 'created_at', 'caregiver']
    search_fields = ['name', 'phone_number']
    readonly_fields = ['created_at', 'updated_at']
    
    fieldsets = (
        ('Basic Information', {
            'fields': ('name', 'phone_number', 'age', 'timezone')
        }),
        ('Preferences', {
            'fields': ('preferred_call_times', 'interests', 'health_notes')
        }),
        ('Relationship', {
            'fields': ('caregiver',)
        }),
        ('Status', {
            'fields': ('is_active',)
        }),
        ('Timestamps', {
            'fields': ('created_at', 'updated_at'),
            'classes': ('collapse',)
        }),
    )