# Generated by Django 5.2.7 on 2025-10-13 06:13

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Senior',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Full name of the senior', max_length=100)),
                ('phone_number', models.CharField(help_text='Phone number in international format (e.g., +1234567890)', max_length=15, validators=[django.core.validators.RegexValidator(message="Phone number must be entered in the format: '+999999999'. Up to 15 digits allowed.", regex='^\\+?1?\\d{9,15}$')])),
                ('age', models.PositiveIntegerField(blank=True, help_text='Age of the senior', null=True)),
                ('timezone', models.CharField(default='UTC', help_text='Timezone for scheduling calls', max_length=50)),
                ('preferred_call_times', models.JSONField(default=list, help_text="List of preferred call times (e.g., ['morning', 'afternoon'])")),
                ('interests', models.JSONField(default=list, help_text='List of interests and topics the senior enjoys discussing')),
                ('health_notes', models.TextField(blank=True, help_text='Any health-related notes or considerations for conversations')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('is_active', models.BooleanField(default=True, help_text='Whether this senior is currently active')),
                ('caregiver', models.ForeignKey(help_text="The caregiver or family member managing this senior's profile", on_delete=django.db.models.deletion.CASCADE, related_name='seniors', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['name'],
                'unique_together': {('phone_number', 'caregiver')},
            },
        ),
    ]
