#!/bin/bash

# Start Celery Worker and Beat for Senior Engagement App
# This script starts both the Celery worker and Celery Beat scheduler

echo "🚀 Starting Senior Engagement App Celery Services..."

# Change to project directory
cd /home/nitin/Desktop/Philip

# Activate virtual environment
source venv/bin/activate

# Check if Redis is running
if ! redis-cli ping > /dev/null 2>&1; then
    echo "❌ Redis is not running. Please start Redis first:"
    echo "   redis-server"
    exit 1
fi

echo "✅ Redis is running"

# Start Celery Worker in background
echo "🔄 Starting Celery Worker..."
celery -A senior_engagement_app worker --loglevel=info --detach

# Start Celery Beat in background  
echo "⏰ Starting Celery Beat (Periodic Tasks)..."
celery -A senior_engagement_app beat --loglevel=info --detach

echo ""
echo "✅ Celery services started successfully!"
echo ""
echo "📋 Services running:"
echo "   - Celery Worker: Processing tasks"
echo "   - Celery Beat: Running periodic tasks every 10 seconds"
echo ""
echo "🔍 Monitor logs:"
echo "   - Worker logs: tail -f /tmp/celery_worker.log"
echo "   - Beat logs: tail -f /tmp/celery_beat.log"
echo ""
echo "🛑 To stop services:"
echo "   pkill -f 'celery.*senior_engagement_app'"
echo ""
echo "📊 Check periodic tasks:"
echo "   python manage.py shell -c \"from django_celery_beat.models import PeriodicTask; print(PeriodicTask.objects.all())\""
