# Generated by Django 5.2.7 on 2025-10-13 06:13

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('seniors', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Call',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('twilio_sid', models.CharField(blank=True, help_text='Twilio Call SID', max_length=100, null=True, unique=True)),
                ('twilio_status', models.CharField(choices=[('initiated', 'Initiated'), ('ringing', 'Ringing'), ('answered', 'Answered'), ('completed', 'Completed'), ('failed', 'Failed'), ('busy', 'Busy'), ('no_answer', 'No Answer'), ('cancelled', 'Cancelled')], default='initiated', help_text='Status of the call', max_length=20)),
                ('duration', models.PositiveIntegerField(blank=True, help_text='Call duration in seconds', null=True)),
                ('call_start_time', models.DateTimeField(blank=True, help_text='When the call actually started', null=True)),
                ('call_end_time', models.DateTimeField(blank=True, help_text='When the call ended', null=True)),
                ('vapi_call_id', models.CharField(blank=True, help_text='Vapi.ai call ID', max_length=100, null=True)),
                ('vapi_status', models.CharField(blank=True, help_text='Vapi.ai call status', max_length=50, null=True)),
                ('ai_prompt', models.TextField(blank=True, help_text='The AI prompt used for this call (includes memory context)')),
                ('call_purpose', models.CharField(default='general_checkin', help_text="Purpose of the call (e.g., 'general_checkin', 'birthday_call')", max_length=200)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('initiated_by', models.ForeignKey(blank=True, help_text='User who initiated the call', null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('senior', models.ForeignKey(help_text='The senior who received the call', on_delete=django.db.models.deletion.CASCADE, related_name='calls', to='seniors.senior')),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='CallLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('event_type', models.CharField(choices=[('initiated', 'Call Initiated'), ('twilio_created', 'Twilio Call Created'), ('vapi_started', 'Vapi Call Started'), ('answered', 'Call Answered'), ('completed', 'Call Completed'), ('failed', 'Call Failed'), ('status_changed', 'Status Changed'), ('webhook_received', 'Webhook Received')], help_text='Type of event logged', max_length=20)),
                ('message', models.TextField(help_text='Log message')),
                ('data', models.JSONField(default=dict, help_text='Additional data related to the event')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('call', models.ForeignKey(help_text='The call this log entry belongs to', on_delete=django.db.models.deletion.CASCADE, related_name='logs', to='calls.call')),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
    ]
