# Generated by Django 5.2.7 on 2025-11-14 04:51

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('calls', '0002_call_vapi_assistant_id'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AlterField(
            model_name='call',
            name='ai_prompt',
            field=models.TextField(blank=True, help_text='The AI prompt used for this call (includes memory context and prompt template)'),
        ),
        migrations.CreateModel(
            name='CallPrompt',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text="A descriptive name for this prompt (e.g., 'General Check-in', 'Birthday Call')", max_length=200)),
                ('description', models.TextField(blank=True, help_text='Description of when and how to use this prompt')),
                ('prompt_template', models.TextField(help_text='The prompt template. Use {senior_name}, {senior_age}, {interests}, {health_notes}, {call_purpose}, and {conversation_context} as placeholders.')),
                ('is_active', models.BooleanField(default=True, help_text='Whether this prompt is available for use')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('created_by', models.ForeignKey(blank=True, help_text='User who created this prompt', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='created_prompts', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Call Prompt',
                'verbose_name_plural': 'Call Prompts',
                'ordering': ['-created_at'],
            },
        ),
        migrations.AddField(
            model_name='call',
            name='prompt',
            field=models.ForeignKey(blank=True, help_text='The prompt template selected for this call', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='calls', to='calls.callprompt'),
        ),
    ]
