# Generated manually to clean up duplicate default prompts

from django.db import migrations


def cleanup_default_prompts(apps, schema_editor):
    """Ensure only one prompt is marked as default"""
    CallPrompt = apps.get_model('calls', 'CallPrompt')
    
    # Get all prompts marked as default
    default_prompts = CallPrompt.objects.filter(is_default=True).order_by('-created_at')
    
    # If there are multiple defaults, keep only the most recent one
    if default_prompts.count() > 1:
        # Keep the first (most recent) one, unset all others
        default_prompts[1:].update(is_default=False)


def reverse_cleanup(apps, schema_editor):
    """Reverse migration - do nothing"""
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('calls', '0004_callprompt_is_default_and_more'),
    ]

    operations = [
        migrations.RunPython(cleanup_default_prompts, reverse_cleanup),
    ]

