from django import template

register = template.Library()


@register.filter
def length_is(value, arg):
    """
    Template filter to check if the length of a value equals the argument.
    This replaces the deprecated 'length_is' filter removed in Django 5.0+.
    
    Usage: {{ value|length_is:"1" }}
    """
    try:
        return len(value) == int(arg)
    except (ValueError, TypeError):
        return False

