from rest_framework import serializers
from seniors.serializers import SeniorSerializer
from calls.serializers import CallSerializer
from .models import Conversation, Memory, ConversationInsight


class ConversationSerializer(serializers.ModelSerializer):
    """Serializer for Conversation model"""
    
    senior = SeniorSerializer(source='call.senior', read_only=True)
    call = CallSerializer(read_only=True)
    duration = serializers.ReadOnlyField()
    is_meaningful = serializers.ReadOnlyField()
    
    class Meta:
        model = Conversation
        fields = [
            'id', 'call', 'senior', 'transcript', 'summary',
            'topics_discussed', 'key_memories', 'emotions_detected',
            'sentiment_score', 'engagement_level', 'follow_up_topics',
            'follow_up_questions', 'duration', 'is_meaningful',
            'created_at', 'updated_at'
        ]
        read_only_fields = ['id', 'created_at', 'updated_at']


class MemorySerializer(serializers.ModelSerializer):
    """Serializer for Memory model"""
    
    senior = SeniorSerializer(read_only=True)
    
    class Meta:
        model = Memory
        fields = [
            'id', 'senior', 'conversation', 'memory_type', 'title',
            'content', 'importance_score', 'tags', 'times_referenced',
            'last_referenced', 'created_at', 'updated_at'
        ]
        read_only_fields = [
            'id', 'times_referenced', 'last_referenced',
            'created_at', 'updated_at'
        ]


class ConversationInsightSerializer(serializers.ModelSerializer):
    """Serializer for ConversationInsight model"""
    
    senior = SeniorSerializer(read_only=True)
    
    class Meta:
        model = ConversationInsight
        fields = [
            'id', 'senior', 'insight_type', 'title', 'description',
            'data', 'confidence_score', 'created_at', 'updated_at'
        ]
        read_only_fields = ['id', 'created_at', 'updated_at']
