from django.urls import path, include
from rest_framework.routers import DefaultRouter
from .views import ConversationViewSet, MemoryViewSet, ConversationInsightViewSet

router = DefaultRouter()
router.register(r'conversations', ConversationViewSet, basename='conversation')
router.register(r'memories', MemoryViewSet, basename='memory')
router.register(r'insights', ConversationInsightViewSet, basename='insight')

urlpatterns = [
    path('', include(router.urls)),
]
