"""
Custom middleware to exempt API routes from CSRF protection.
"""
from django.utils.deprecation import MiddlewareMixin


class DisableCSRFForAPI(MiddlewareMixin):
    """
    Middleware to disable CSRF protection for API endpoints.
    This is safe because REST APIs typically use token-based authentication
    or other authentication methods that don't require CSRF protection.
    
    This middleware must be placed BEFORE CsrfViewMiddleware in MIDDLEWARE settings.
    """
    
    def process_request(self, request):
        # Exempt all API routes from CSRF
        if request.path.startswith('/api/'):
            setattr(request, '_dont_enforce_csrf_checks', True)
        return None

