
import pprint
import stripe
import os
import uuid

from flask import Flask, request, jsonify
from flask_cors import CORS
from supabase import create_client

from main.create_subscription import create_subscription
from main.create_customer import create_customer
from main.add_seat import add_seat
from main.remove_seat import remove_seat
from main.check_subscription import check_subscription


app = Flask(__name__)
CORS(app)

stripe_keys = {
    "dev": "sk_test_51OjTcIEe9LS4zP94F3C87zQRneHT6myzvddVTaissvfPvmMI8TieFkPrHgRhinDuco6j0QqIzXZRYJ6MCxFlQEKb00n3krrcHo",
    # "prod": os.environ.get("PROD_KEY")
}

price_ids = {
    "dev": "price_1PWGVFEe9LS4zP94VTz93111",
    # "prod": "price_1OzHxkEe9LS4zP94yPH20Vuu"
}

supabase_keys = {
    "dev": {
        "url": "https://uortgjlgadxkdpoehcmq.supabase.co",
        "key": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6InVvcnRnamxnYWR4a2Rwb2VoY21xIiwicm9sZSI6InNlcnZpY2Vfcm9sZSIsImlhdCI6MTcxNzQyOTkzNiwiZXhwIjoyMDMzMDA1OTM2fQ.BDPk6TQZVLCWSgv-3y1jTdhO8uya5zlxbfkzFOQsEZE"
    },
}

def get_supabase_client():
    dev = request.json["dev"]
    dev == "development_key_01"
    stripe.api_key = stripe_keys['dev']
    config = supabase_keys['dev']

    return create_client(config['url'], config['key'])

@app.route("/new-subscribing-customer", methods=["POST"])
def main():
    data = request.json
    name = data['name']
    email = data['email']
    user_id = data["user_id"]
    team_id = data["team_id"]
    address = data["address"]
    days = data["days"]
    quantity = data["amount"]

    dev = data['dev']

    dev == "development_key_01"
    stripe.api_key = stripe_keys['dev']
    price_id = price_ids['dev']
    
    customer = create_customer(name, email, user_id, team_id, address)

    supabase = get_supabase_client()
    subscription = create_subscription(customer_id=customer.id, supabase=supabase, team_id=team_id, trial_period_days=days, quantity=quantity, price_id=price_id)

    team_id = uuid.UUID(team_id)

    response = supabase.table("TeamTable").update({"SubscriptionID": subscription["id"]}).eq("TeamID", team_id).execute()

    return {"Customer ID": customer.id, "Subscription ID": subscription.id}

@app.route("/new-seat", methods=["POST"])
def new_seat():
    data = request.json
    subscription_id = data["sub_id"]
    
    dev = data["dev"]


    stripe.api_key = stripe_keys['dev']


    seat = add_seat(subscription_id=subscription_id)

    return {"updated_subscription_item": seat} 

@app.route("/remove-seat", methods=["POST"])
def one_less_seat():
    data = request.json
    subscription_id = data["sub_id"]
    
    dev = data["dev"]

    dev == "development_key_01"
    stripe.api_key = stripe_keys['dev']


    seat = remove_seat(subscription_id=subscription_id)
    return {"updated_subscription_item":seat}

@app.route("/check-subscription", methods=["POST"])
def check():
    data = request.json
    subscription_id = data["sub_id"]
    supabase = get_supabase_client()

    dev = data['dev']

    dev == "development_key_01"
    price_id = price_ids['dev']

    if 'quantity' in data:
        quantity = data['quantity']
        team_id = data['team_id']
        result = check_subscription(subscription_id, supabase, price_id, quantity, team_id)
    else:
        team_id = data.get('team_id', "")
        result = check_subscription(subscription_id, supabase, price_id, team_id=team_id)
        
    return (result)
    

@app.route("/subscription-details", methods=["POST"])
def subscription_details():
    data = request.json
    
    if not data or 'sub_id' not in data or 'dev' not in data:
        return {"error": "Missing required parameters"}, 400

    subscription_id = data["sub_id"]
    dev = data["dev"]
    
    dev == "development_key_01"
    stripe.api_key = stripe_keys['dev']

    try:
        subscription = stripe.Subscription.retrieve(subscription_id)
        
        customer = stripe.Customer.retrieve(subscription.customer)

        portal_session = stripe.billing_portal.Session.create(customer=subscription["customer"])
        portal = portal_session.url
        

        subscription_details = {
            "sub": subscription,
            "cus": customer,
            "port": portal
        }
        
        return subscription_details, 200

    except stripe.error.StripeError as e:
        return {"error": str(e)}, 400
    except Exception as e:
        return e, 500
    
    
    

