import stripe

def add_seat(subscription_id):
    try:
        subscription = stripe.Subscription.retrieve(subscription_id)

        if subscription['items']['total_count'] > 0:
            first_item_id = subscription['items']['data'][0]['id']
            current_quantity = subscription['items']['data'][0]['quantity']

            updated_subscription_item = stripe.SubscriptionItem.modify(
                first_item_id,
                quantity=current_quantity + 1  
            )
            return updated_subscription_item
        else:
            print("No items found in subscription.")
            return None

    except Exception as e:
        print(f"An error occurred: {e}")
        return None