import stripe

def create_subscription(customer_id, supabase, team_id, price_id, trial_period_days=14, quantity=1):
    try:
        subscription = stripe.Subscription.create(
            customer=customer_id,
            items=[
                {
                    "price": price_id,
                    "quantity": quantity
                }
            ],
            trial_period_days=trial_period_days, 
            proration_behavior="create_prorations",
            expand=["latest_invoice.payment_intent"],
            automatic_tax={"enabled": True}  
        )

        return subscription
        
    except:
        return None
    
