from django.views.generic.base import View
from django.views.generic import TemplateView
from django.contrib.auth import authenticate, login, logout
from django.shortcuts import render, redirect
from django.http.response import HttpResponse
from admin_panel.models import SuperAdmin
from . import forms
from django.contrib import messages
from django.core import mail
from django.template.loader import render_to_string
import math, random, string
from django.conf import settings
from django.core.paginator import Paginator
from django.http import JsonResponse
from django.contrib.auth.decorators import login_required
from django.utils.decorators import method_decorator
from django.db.models import Q,Sum
import datetime
import json
from django.db.models import Count
import ast
from django.views.generic import TemplateView
import datetime
from django.http import HttpResponseRedirect
from django.utils import timezone
import csv
from collections import defaultdict
from passlib.hash import django_pbkdf2_sha256 as handler
from apps.artiste.models import Album, Artiste, AudioMedia,BankAccount

from profiles.models import UserPacksTranscation
from django.core.files.storage import FileSystemStorage
import os
import random,string
from django.contrib.auth import get_user_model


User = get_user_model()

def randomStringFunctionForImage():
    import random,string
    str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
    str1 += ''.join((random.choice(string.digits) for x in range(4)))
    sam_list = list(str1)
    random.shuffle(sam_list)
    finalString = ''.join(sam_list)
    return finalString

def uploadTheImages(image):
    fullPath='mediafiles'
    fs = FileSystemStorage(location=fullPath)
    fullPath2='mediafiles'
    filetype = os.path.splitext(image.name)[1]
    theName=randomStringFunctionForImage()
    theImageName=str(theName)+str(filetype)
    filename = fs.save(theImageName, image)
    return str(fullPath2)+'/'+filename

# def checkEmail(request):
# 	text = request.GET.get('email')
# 	post = User.objects.filter(email=text,is_superuser = 1).first()
# 	if post:
# 		return HttpResponse ('true')
# 	else:
# 		message = 'This email does not exist in our database'
# 		return JsonResponse(message,safe=False)



# def checkLoginPassword(request):
# 	text = request.GET.get('email','')
# 	password = request.GET.get('password')
# 	user         = User.objects.get(email=text,is_superuser = 1)
# 	if user.check_password(password) == False:
# 		message = 'Please enter the correct password'
# 		return JsonResponse(message,safe=False)
# 	else:
# 		return HttpResponse ('true')

# def adminCheckPassword(request):
# 	old_password = request.GET.get('old_password')
# 	user         = User.objects.get(email=request.user.email,is_superuser = 1)
# 	if user.check_password(old_password) == False:
# 		message = 'Does not match with the old password.'
# 		return JsonResponse(message,safe=False)
# 	else:
# 		return HttpResponse ('true')



class AdminLogIn(TemplateView):
	template_name = 'admin-signin.html'
	def get(self,request):
		if(request.user.is_authenticated):
			return HttpResponseRedirect('admin-profile')
		return render(request,self.template_name)
	
	def post(self,request):
		try:
			form = forms.AdminSigninForm(request.POST)
			if form.is_valid():
				email    = form.cleaned_data.get('email')
				password = form.cleaned_data.get('password')
				user = authenticate(email=email, password=password)
				if user:
					login(request, user)
					messages.success(request, "Login successfully")
					return redirect('admin-profile')

				else:
					messages.success(request, "Invalid email and password.")
					return render(request, self.template_name)
			else:
				return render(request,self.template_name, {'form': form})
		except Exception as e:
			messages.warning(request, "Something went wrong.Please try again.")
			return redirect('admin-login')     




class AdminProfile(TemplateView):
	template_name = 'admin_profile.html'
	# @method_decorator(login_required(login_url='/'))
	def get(self,request):
		admin_obj = SuperAdmin.objects.filter(user=request.user.id).first()
		return render(request,self.template_name,{'admin_obj':admin_obj})

		
	def post(self,request):
		try:
			form = forms.AdminProfileForm(request.POST)
			if form.is_valid(): 
				first_name = form.cleaned_data.get('first_name')
				last_name = form.cleaned_data.get('last_name')
				email = form.cleaned_data.get('email')
				phone_number = form.cleaned_data.get('phone_number')
				address = form.cleaned_data.get('address')
				SuperAdmin.objects.filter(user=request.user.id).update(firstName=first_name,lastName=last_name,email=email,phoneNumber=phone_number,address=address)
				if request.FILES.get('avatar'):
					fileUrl = uploadTheImages(request.FILES.get('avatar'))
					fileUrl='/'+fileUrl
					SuperAdmin.objects.filter(user=request.user.id).update(image=str(fileUrl))
				messages.success(request, "Update Succesfully")
				return redirect('admin-profile')
			else:
				return render(request,self.template_name)
		except Exception as e:
			messages.warning(request, "Something went wrong.Please try again.")
			return redirect('admin-profile')




class getArtistListing(TemplateView):
	template_name = 'artist_listing.html'
	def get(self,request):
		search_term = request.GET.get('search', '')
		if search_term:
			data_obj = Artiste.objects.filter(
				Q(stage_name__icontains=search_term) | Q(arts__icontains=search_term)
			).order_by('-id')
		else:
			data_obj = Artiste.objects.all().order_by('-id')
		paginator = Paginator(data_obj, 12)
		page_number = request.GET.get('page')
		artist_obj = paginator.get_page(page_number)
		return render(request,self.template_name,{'artist_obj':artist_obj})



class getBankDetails(TemplateView):
	template_name = 'bank_details.html'
	def get(self,request,id):
		bank_obj = BankAccount.objects.filter(user = id).first()
		return render(request,self.template_name,{'bank_obj':bank_obj})



class getArtisitDonations(TemplateView):
	template_name = 'donation_listing.html'
	def get(self,request):
		data_obj = UserPacksTranscation.objects.all().order_by('-id')
		paginator = Paginator(data_obj, 12)
		page_number = request.GET.get('page')
		trans_obj = paginator.get_page(page_number)
		return render(request,self.template_name,{'trans_obj':trans_obj})


class AdminLogout(TemplateView):
	@method_decorator(login_required(login_url='/admin-login'))
	def get(self,request):
		logout(request)
		messages.success(request, "Logout Succesfully")
		return redirect('/admin-login')


class markPayoutComplete(TemplateView):
	def get(self,request,id):
		pay_obj =  UserPacksTranscation.objects.filter(id = id).first()
		pay_obj.status = "Completed"
		pay_obj.save()
		subject = "Payout completed successfully"
		html_message = render_to_string('payout_success_email.html', {'amount': pay_obj.amount,'request_data':pay_obj.created_at,'artist_name':pay_obj.artiste.stage_name})
		plain_message = html_message
		from_email = settings.EMAIL_HOST_USER
		to = pay_obj.artiste.user.email
		mail.send_mail(subject, plain_message, from_email, [to], html_message=html_message)
		return redirect('get-artist-donations')


		
		
class AdminResetPassword(TemplateView):
	template_name = 'admin_reset_password.html'
	@method_decorator(login_required(login_url='/admin-login'))
	def get(self,request):
		return render(request,self.template_name,locals())

	def post(self,request):
		try:
			form = forms.ChangePasswordForm(request.POST)
			if form.is_valid():
				password = request.POST.get("confirmPassword")
				user     = User.objects.get(email=request.user.email)
				user.set_password(password)
				user.save()
				logout(request)
				messages.info(request, 'You have successfully reset your password')
				return redirect('/admin-login')
			else:
				
				return render(request, 'admin_reset_password.html', {'form': form})
		except Exception as e:
			messages.warning(request, "Something went wrong.Please try again.")
			return redirect('admin-profile') 
		