from django.contrib import admin

# Register your models here.
from apps.actions.models import Follow, MediaLikes, VerificationRequests, PrivacyPolicy
from apps.artiste.constants import REJECTED, REQUESTED_VERIFICATION, VERIFIED

admin.site.register(PrivacyPolicy)
admin.site.register(MediaLikes)
admin.site.register(Follow)


def approve_verification_requests(modeladmin, request, queryset):
    for artist in queryset:
        artist.verification_status = VERIFIED
        artist.save()


def reject_verification_requests(modeladmin, request, queryset):
    for artist in queryset:
        artist.verification_status = REJECTED
        artist.save()


@admin.register(VerificationRequests)
class VerificationRequestAdmin(admin.ModelAdmin):
    list_display = ("user", "stage_name")
    actions = (approve_verification_requests, reject_verification_requests)

    def email(self, obj):
        return obj.user.email

    def get_queryset(self, request):
        return super().get_queryset(request).filter(verification_status=REQUESTED_VERIFICATION)

    def has_delete_permission(self, request, obj=None):
        return False

    def has_add_permission(self, request):
        return False
