from typing import Any

from rest_framework import serializers

from apps.actions.constants import ACTION_DISLIKE, ACTION_LIKE
from apps.actions.models import Follow, MediaLikes, PrivacyPolicy


class LikeMediaSerializer(serializers.ModelSerializer):
    class Meta:
        model = MediaLikes
        fields = '__all__'
        read_only_fields = ('fan', 'media', 'action_type')

    def create(self, validated_data: Any):
        return MediaLikes.objects.create(
            fan=self.context['fan'], media=self.context['audio_media'], action_type=ACTION_LIKE
        )


class FollowArtisteSerializer(serializers.ModelSerializer):
    class Meta:
        model = Follow
        fields = '__all__'
        read_only_fields = ('fan', 'artiste')


class PrivacyPolicySerializer(serializers.ModelSerializer):
    class Meta:
        model = PrivacyPolicy
        fields = '__all__'
        read_only_fields = ["id"]
