from django.urls import path, include
from rest_framework import routers

from apps.actions.api.v1.views import (
    AcceptPrivacyPolicyAPIView,
    AcceptTermsAndConditionsAPIView,
    DislikeMediaAPIView,
    FollowUnfollowArtisteAPIView,
    LikeMediaAPIView,
    RequestVerificationAPIView,
    TrimSongAPIView, PrivacyPolicyAPIView,
)

router = routers.DefaultRouter()
router.register('privacy_policy', PrivacyPolicyAPIView, basename='privacy_policy')

app_name = "actions_api"

urlpatterns = [
    path('like-media/<str:media_uuid>/', LikeMediaAPIView.as_view(), name='like_media'),
    path('dislike-media/<str:media_uuid>/', DislikeMediaAPIView.as_view(), name='dislike_media'),
    path(
        'follow-unfollow-artiste/<str:artiste_uuid>/',
        FollowUnfollowArtisteAPIView.as_view(),
        name='follow_unfollow_artiste',
    ),
    path('terms-and-conditions/', AcceptTermsAndConditionsAPIView.as_view(), name='terms_and_conditions'),
    path('accept-privacy-policy/', AcceptPrivacyPolicyAPIView.as_view(), name='privacy_policy'),
    path('request-verification/', RequestVerificationAPIView.as_view(), name='request_verification'),
    path('trim-song/', TrimSongAPIView.as_view(), name='trim_song'),
    path('', include(router.urls))
]
