import uuid

from django.db import models

from apps.actions.constants import ACTION_CHOICES
from apps.artiste.models import Artiste
from apps.lib.base_model import BaseAbstractModel


# Create your models here.
class MediaLikes(BaseAbstractModel):
    id = models.UUIDField(primary_key=True, default=uuid.uuid4, editable=False)
    media = models.ForeignKey('artiste.AudioMedia', on_delete=models.CASCADE, related_name='likes')
    fan = models.ForeignKey('users.Fan', on_delete=models.CASCADE, related_name='media_likes')
    action_type = models.IntegerField(choices=ACTION_CHOICES, null=True, blank=True)

    class Meta:
        unique_together = ('fan', 'media')

    def __str__(self):
        return f'{self.fan} {self.get_action_type_display()} {self.media}'


class Follow(BaseAbstractModel):
    id = models.UUIDField(primary_key=True, default=uuid.uuid4, editable=False)
    fan = models.ForeignKey('users.Fan', on_delete=models.CASCADE, related_name='follows')
    artiste = models.ForeignKey('artiste.Artiste', on_delete=models.CASCADE, related_name='followers')

    class Meta:
        unique_together = ('fan', 'artiste')

    def __str__(self):
        return f'{self.fan} follows {self.artiste}'


class VerificationRequests(Artiste):
    class Meta:
        proxy = True
        verbose_name_plural = "Verification requests"


class PrivacyPolicy(models.Model):
    id = models.UUIDField(primary_key=True, default=uuid.uuid4)
    content = models.TextField()
    created_at = models.DateTimeField(
        auto_now_add=True,
    )
    updated_at = models.DateTimeField(
        auto_now=True,
    )

    def __str__(self):
        return f'{self.id}'
