from django.contrib import admin
from django.contrib.admin import register
# Register your models here.
from apps.artiste.models import Album, Artiste, AudioMedia, Links, VideoMedia

# admin.site.register(Artiste)
# admin.site.register(AudioMedia)
admin.site.register(VideoMedia)
# admin.site.register(Album)
admin.site.register(Links)


@register(Artiste)
class ArtisteAdmin(admin.ModelAdmin):
    list_display = ['stage_name', 'user', 'verification_status']
    list_filter = ['user']
    search_fields = ['user__email', 'stage_name', 'user__first_name', 'user__last_name']


@register(AudioMedia)
class AudioMediaAdmin(admin.ModelAdmin):
    list_display = ['title', 'artiste', 'album']
    list_filter = ['artiste']
    search_fields = ['title', 'artiste__stage_name']


@register(Album)
class AlbumAdmin(admin.ModelAdmin):
    list_display = ['album_name', 'artiste']
    list_filter = ['artiste']
    search_fields = ['album_name', 'artiste__stage_name']
