from django.urls import path

from apps.artiste.api.v1.views import (
    AlbumSongsAPIView,
    ArtisteAlbumsAPIView,
    ArtisteFollowedAPIView,
    ArtisteFollowersAPIView,
    ArtisteProfileAPIView,
    ArtisteSongsAPIView,
    CreateAlbumAPIView,
    CreateSongAPIView,
    DeleteAlbumAPIView,
    DeleteSongAPIView,
    ListAllArtisteAPIView,
    SelectProfileSongAPIView,
    AddBankAccountAPIView,
    AddFcmToken
)

app_name = "artiste_api"

urlpatterns = [
    path('', ListAllArtisteAPIView.as_view(), name='list_all_artiste'),
    path('artiste-profile/<str:artiste_uuid>/', ArtisteProfileAPIView.as_view(), name='artiste_profile'),
    path('artiste-albums/<str:artiste_uuid>/', ArtisteAlbumsAPIView.as_view(), name='artiste_albums'),
    path('artiste-followed/', ArtisteFollowedAPIView.as_view(), name='artiste_followed'),
    path('artiste-followers/', ArtisteFollowersAPIView.as_view(), name='artiste_followers'),
    path('albums-songs/<str:album_uuid>/', AlbumSongsAPIView.as_view(), name='albums_audios'),
    path('create-album/', CreateAlbumAPIView.as_view(), name='create_album'),
    path('delete-album/<str:album_uuid>/', DeleteAlbumAPIView.as_view(), name='delete_album'),
    path('create-song/', CreateSongAPIView.as_view(), name='create_song'),
    path('delete-song/<str:audio_uuid>/', DeleteSongAPIView.as_view(), name='delete_song'),
    path('artiste-songs/<str:artiste_uuid>/', ArtisteSongsAPIView.as_view(), name='artiste_audios'),
    path('select-profile-song/', SelectProfileSongAPIView.as_view(), name='select_profile_song'),
    path('add-bank-account/', AddBankAccountAPIView.as_view(), name='add-bank-account'),
    path('add-fcm-token/', AddFcmToken.as_view(), name='add-fcm-token/'),
    
    
]
